/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.common.util;

import com.hcl.appscan.ifa.common.IIfaLayer;
import com.hcl.appscan.ifa.common.IfaTarget;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.common.logging.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;

public class FindingCompressorIfaLayer
implements IIfaLayer {
    private Function<Finding, Object> m_compressor;
    private IIfaLayer m_layer;

    public FindingCompressorIfaLayer(Function<Finding, Object> compressor, IIfaLayer layer) {
        this.m_compressor = compressor;
        this.m_layer = layer;
    }

    @Override
    public void applyIfa(IfaTarget t) {
        class FindingBin {
            private Finding finding;
            private String note;
            private ArrayList<Finding> bin = new ArrayList();

            public FindingBin(Finding f) {
                this.finding = f;
                this.note = f.getNote();
                this.finding.getData().setNote(null);
            }
        }
        HashMap compression_map = new HashMap();
        IfaTarget sub_t = t.slice(f -> {
            Object key = this.m_compressor.apply((Finding)f);
            if (compression_map.containsKey(key)) {
                ((FindingBin)compression_map.get(key)).bin.add(f);
                return false;
            }
            compression_map.put(key, new FindingBin((Finding)f));
            return true;
        });
        t.addMessage(new Message(1, this.getIfaName() + " compressed " + t.size() + " to " + sub_t.size()));
        this.m_layer.applyIfa(sub_t);
        for (FindingBin findingBin : compression_map.values()) {
            String newNote = findingBin.finding.getNote();
            findingBin.finding.getData().setNote(findingBin.note);
            if (newNote == null) continue;
            this.appendNote(findingBin.finding, newNote);
            findingBin.bin.forEach(f -> this.appendNote((Finding)f, newNote));
        }
        sub_t.forEach(f -> {
            FindingBin cfr_ignored_0 = (FindingBin)compression_map.remove(this.m_compressor.apply((Finding)f));
        });
        for (FindingBin findingBin : compression_map.values()) {
            Boolean excluded = findingBin.finding.isExcluded();
            for (Finding f2 : findingBin.bin) {
                if (excluded.booleanValue()) {
                    t.excludeFinding(f2);
                    continue;
                }
                t.includeFinding(f2);
            }
        }
    }

    private void appendNote(Finding f, String additionalNote) {
        String currentNote = f.getData().getNote();
        currentNote = currentNote == null ? additionalNote : currentNote + System.getProperty("line.separator") + additionalNote;
        f.getData().setNote(currentNote);
    }

    @Override
    public void close() throws Exception {
        this.m_layer.close();
    }

    @Override
    public String getIfaName() {
        return this.getClass().getSimpleName() + "(" + this.m_layer.getIfaName() + ")";
    }
}

