using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection.Emit;
using System.Reflection;

namespace CSharp
{
    class InlineBrTargetInstruction : ILInstruction
    {
        private readonly Int32 branchTarget;

        public InlineBrTargetInstruction(MethodBase enclosingMethod, OpCode opcode, Int32 offset, Int32 branchTarget)
            : base(enclosingMethod, opcode, offset)
        { 
            this.branchTarget = branchTarget;
        }

        public Int32 BranchTarget
        {
            get { return this.branchTarget; }  
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder(base.ToString());
            sb.Append(" ");
            sb.Append(branchTarget);
            return sb.ToString();
        }
    }
}
