using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection.Emit;
using System.Reflection;

namespace CSharp
{
    class ShortInlineBrTargetInstruction : ILInstruction
    {
        private readonly Int16 branchTarget;

        public ShortInlineBrTargetInstruction(MethodBase enclosingMethod, OpCode opcode, Int32 offset, Int16 branchTarget)
            : base(enclosingMethod, opcode, offset)
        {
            this.branchTarget = branchTarget;
        }

        public Int16 BranchTarget
        {
            get
            {
                return this.branchTarget;
            }
        }
    }
}
