using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace CSharpImpl
{
    public class AssemblyInfo
    {
        #region Fields
        private readonly Assembly assembly;
        private Vector<ClassInfo> classes;
        #endregion

        #region CTOR
        public AssemblyInfo(Assembly assembly)
        {
            this.assembly = assembly;
        }
        #endregion

        #region Properties
        public Assembly Assembly
        {
            get
            {
                return assembly;
            }
        }

        public String Name
        {
            get
            {
                return this.assembly.GetName().ToString();
            }
        }

        public Int32 ClassCount
        {
            get
            {
                return Classes.Count;
            }
        }

        public Vector<ClassInfo> Classes
        {
            get
            {
                if (this.classes == null)
                {
                    this.classes = ComputeClasses();
                }
                return this.classes;
            }
        }
        #endregion

        #region Methods
        public override int GetHashCode()
        {
            return assembly.GetHashCode();
        }

        public override Boolean Equals(object obj)
        {
            if (obj is AssemblyInfo)
            {
                AssemblyInfo otherAI = (AssemblyInfo) obj;
                return this.assembly.Equals(otherAI.assembly);
            }
            return false;
        }

        public String[] GetRefrencedAssamblies()
        {
            AssemblyName[] assamblyNames = assembly.GetReferencedAssemblies();
            String[] res = new String[assamblyNames.Length];
            int i = 0;
            foreach (AssemblyName name in assamblyNames)
            {
                res[i++] = name.FullName;
            }
            return res;
        }

        private Vector<ClassInfo> ComputeClasses()
        {
            Vector<ClassInfo> result = new Vector<ClassInfo>(1);
            try
            {
                foreach (Type type in assembly.GetTypes())
                {
                    result.Add(new ClassInfo(type));
                }
            }
            catch (System.Reflection.ReflectionTypeLoadException e)
            {
				/*
                foreach (Type type in e.Types)
                {
                    result.Add(new ClassInfo(type));
                }
                */
            }
            return result;
        }
        #endregion
    }
}
