using System;
using System.Collections.Generic;
using System.Text;

namespace CSharpImpl
{
    public class FieldInfo
    {
        #region Fields
        private readonly System.Reflection.FieldInfo field;
        #endregion

        #region CTOR(s)
        public FieldInfo(System.Reflection.FieldInfo field)
        {
            this.field          = field;
        }
        #endregion

        #region Methods
        public override bool Equals(object obj)
        {
            if (obj is FieldInfo)
            {
                FieldInfo other = obj as FieldInfo;
                return (other.field.Equals(this.field));
            }
            return false;
        }

        public override int GetHashCode()
        {
            return field.GetHashCode();
        }
        #endregion

        #region Properties
        public Boolean IsStatic
        {
            get
            {
                return field.IsStatic;
            }
        }

        public ClassInfo Type
        {
            get
            {
                return new ClassInfo(field.FieldType);
            }
        }

        public String Name
        {
            get
            {
                return field.Name;
            }
        }

        public System.Reflection.FieldInfo Field
        {
            get
            {
                return field;
            }
        }

        public Boolean IsPublic
        {
            get
            {
                return field.IsPublic;
            }
        }

        public Boolean IsPrivate
        {
            get
            {
                return field.IsPrivate;
            }
        }

        public Boolean IsInitOnly
        {
            get
            {
                return field.IsInitOnly;
            }
        }

        public ClassInfo DeclaringClass
        {
            get
            {
                return new ClassInfo(field.DeclaringType);
            }
        }
        #endregion
    }
}
