using System;
using System.Collections.Generic;
using System.Text;

namespace CSharpImpl
{
    public class TwoWayMap<T, K>
    {
        #region Fields
        private readonly Dictionary<T, K> T2K;
        private readonly Dictionary<K, T> K2T;
        #endregion

        #region CTOR(s)
        public TwoWayMap()
        {
            T2K = new Dictionary<T, K>();
            K2T = new Dictionary<K, T>();
        }
        #endregion

        #region Indexers
        public K this[T t]
        {
            get
            {
                return T2K[t];
            }
        }

        public int Count
        {
            get
            {
                System.Diagnostics.Debug.Assert(T2K.Count == K2T.Count);
                return K2T.Count;
            }
        }

        public T this[K k]
        {
            get
            {
                return K2T[k];
            }
        }
        #endregion

        #region Methods
        public void Add(T t, K k)
        {
            T2K.Add(t, k);
            K2T.Add(k, t);
        }

        public void Add(K k, T t)
        {
            T2K.Add(t, k);
            K2T.Add(k, t);
        }

        public void Clear()
        {
            T2K.Clear();
            K2T.Clear();
        }

        public ICollection<L> GetKeys<L>()
        {
            if (typeof(K).Equals(typeof(L)))
            {
                System.Collections.Generic.ICollection<K> keys = new System.Collections.Generic.List<K>(K2T.Keys.Count);
                foreach (K key in K2T.Keys)
                    keys.Add(key);
                return (ICollection<L>) keys;
            }
            else if (typeof(T).Equals(typeof(L)))
            {
                System.Collections.Generic.ICollection<T> keys = new System.Collections.Generic.List<T>(T2K.Keys.Count);
                foreach (T key in T2K.Keys)
                    keys.Add(key);
                return (ICollection<L>)keys;
            }
            else
            {
                System.Diagnostics.Debug.Assert(false);
                return null;
            }
        }

        public Boolean ContainsKey(K k)
        {
            if (k == null)
                return false;
            else
                return K2T.ContainsKey(k);
        }

        public Boolean ContainsKey(T t)
        {
            if (t == null)
                return false;
            else
                return T2K.ContainsKey(t);
        }
        #endregion
    }
}
