// MCPP.h

#pragma once
#using "Driver.netmodule"
/*#using "ExceptionEntry.netmodule"*/
using namespace System;

namespace MCPP {
	public ref class ILReader {
	private:
		static const bool VERBOSE = false;
	public:
		static System::String ^ProcessQuery(System::String ^query) {
			cli::array<System::String ^> ^components = query->Split('$');
			System::Reflection::Assembly ^assembly = System::Reflection::Assembly::LoadFile(components[0]);
			cli::array<System::Reflection::Module ^> ^modules = assembly->GetModules();
			cli::array<System::String ^> ^methodNameElements = components[1]->Split('#'); 
			for (int index = 0; index < modules->Length; ++index) {
				if (VERBOSE) {
					Console::WriteLine(modules[index]);
					cli::array<System::Type ^> ^types=modules[index]->GetTypes();
					for (int j = 0; j < types->Length; ++j) {
						Console::Write("\t");
						Console::WriteLine(types[j]);
					}
				}
				System::Type ^declaringClass = modules[index]->GetType(methodNameElements[0]);
				if (declaringClass != nullptr) {
					if (VERBOSE) {
						cli::array<System::Reflection::MemberInfo ^> ^members = declaringClass->GetMembers(System::Reflection::BindingFlags::NonPublic | System::Reflection::BindingFlags::Instance);
						for (int i = 0; i < members->Length; ++i) {
							Console::Write("\t\t");
							Console::WriteLine(members[i]);
						}
						Console::WriteLine();
					}
					cli::array<System::Reflection::MemberInfo ^> ^matchingMethods = declaringClass->GetMember(methodNameElements[1], System::Reflection::MemberTypes::Method, System::Reflection::BindingFlags::Public | System::Reflection::BindingFlags::Instance);
					if (matchingMethods->Length == 0) {
						matchingMethods = declaringClass->GetMember(methodNameElements[1], System::Reflection::MemberTypes::Method, System::Reflection::BindingFlags::Public | System::Reflection::BindingFlags::Static);
					}
					if (matchingMethods->Length == 0) {
						matchingMethods = declaringClass->GetMember(methodNameElements[1], System::Reflection::MemberTypes::Method, System::Reflection::BindingFlags::NonPublic | System::Reflection::BindingFlags::Instance);
					}
					if (matchingMethods->Length == 0) {
						matchingMethods = declaringClass->GetMember(methodNameElements[1], System::Reflection::MemberTypes::Method, System::Reflection::BindingFlags::NonPublic | System::Reflection::BindingFlags::Static);
					}
					if (matchingMethods->Length > 0) {	
						System::Text::StringBuilder ^sb = gcnew System::Text::StringBuilder();
						for (int k = 0; k < matchingMethods->Length; ++k) {
							System::Reflection::MethodBase ^method = (System::Reflection::MethodBase ^) matchingMethods[k];
							CSharp::ILReader ^reader = gcnew CSharp::ILReader(method);
							sb->Append(reader->ToString());
							if (k < (matchingMethods->Length - 1)) {
								sb->Append('|');
							}
						}
						return sb->ToString();
					}
				}
			}
			return nullptr;
		}
	};
}
