#include "stdafx.h"
#include "com_ibm_wala_dotnet_loader_csharp_CSharpInterface.h"
#include "MCPP.h"
#include "PdbParser.h"
#include <algorithm>

static jmethodID boxMethod;
static jmethodID unboxMethod;

static System::Int32 ToCILInteger(jint javaInt) {
	return (System::Int32) javaInt;
}

static jint ToJavaInteger(System::Int32 integer) {
	return (jint) integer;
}

static jobject BoxInteger(JNIEnv *env, jobject cls, jint i) {	
	return env->CallObjectMethod(cls, boxMethod, i);
}

static jint UnboxInteger(JNIEnv *env, jobject cls, jobject intObject) {	
	return env->CallIntMethod(cls, unboxMethod, intObject);
}

static String ^ToCILString(JNIEnv* env, jstring javaString) {
	if (javaString == nullptr) {
		return nullptr;
	} else {
		const char *rawString = env->GetStringUTFChars(javaString, NULL);
		return gcnew System::String(rawString);
	}
}

static jstring ToJavaString(JNIEnv *env, System::String ^str) {
	const char *pszConverted = (char *) (void *) System::Runtime::InteropServices::Marshal::StringToHGlobalAnsi(str);
	return env->NewStringUTF(pszConverted);
}

JNIEXPORT void JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_init(JNIEnv *env, jclass cls) {
	boxMethod = env->GetMethodID(cls, "box", "(I)Ljava/lang/Integer;");
	unboxMethod = env->GetMethodID(cls, "unbox", "(Ljava/lang/Integer;)I");
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_findImage(JNIEnv *env, jobject cls, jstring str) {
	String ^cilStr = ToCILString(env, str);
	return BoxInteger(env, cls, ToJavaInteger(CSharp::Driver::GetDriver()->FindImage(ToCILString(env, str))));
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetDeclaredInstanceMethods(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->ClassGetDeclaredInstanceMethods(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetDeclaredStaticMethods(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->ClassGetDeclaredStaticMethods(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_imageGetAssemblyNameImpl(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	System::String ^name = CSharp::Driver::GetDriver()->ImageGetAssemblyName(index);
	return ToJavaString(env, name);
}

JNIEXPORT jint JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_numberOfClasses(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	System::Int32 result = CSharp::Driver::GetDriver()->NumberOfClasses(index);
	return ToJavaInteger(result);
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_imageAllClasses(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->ImageAllClasses(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_typeGetName(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	System::String ^name = CSharp::Driver::GetDriver()->ClassGetName(index);
	return ToJavaString(env, name);
}

System::Collections::Generic::KeyValuePair<String ^, System::Collections::Generic::List<String ^> ^> ^MakeSourceMappings(BSTR c, std::vector<BSTR> *v) {
	System::Collections::Generic::List<String ^> ^image = gcnew System::Collections::Generic::List<String ^>(v->size());
	System::String ^s = gcnew System::String(c);
	std::vector<BSTR>::iterator iter;
	for (iter = v->begin(); iter != v->end(); ++iter) {
		BSTR current = (*iter);
		image->Add(gcnew System::String(current));
	}
	return gcnew System::Collections::Generic::KeyValuePair<String ^, System::Collections::Generic::List<String ^> ^>(s, image);
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetSourceFiles(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::String ^> ^result = CSharp::Driver::GetDriver()->ClassGetSourceFiles(index);
	if (result == nullptr) {
		System::String ^pdbPath = CSharp::Driver::GetDriver()->GetPdbPath(CSharp::Driver::GetDriver()->ClassGetImage(index));
		if (pdbPath != nullptr) {
			System::IntPtr nativePdbPath = System::Runtime::InteropServices::Marshal::StringToBSTR(pdbPath);
			LoadDataFromPdb(static_cast<BSTR>(nativePdbPath.ToPointer()));
			System::Runtime::InteropServices::Marshal::FreeBSTR(nativePdbPath);
			std::map<BSTR, std::vector<BSTR> *> *mappings = GetAllSourceFiles();
			std::map<BSTR, std::vector<BSTR> *>::iterator iter;
			System::Collections::Generic::IDictionary<System::String ^, System::Collections::Generic::List<System::String ^> ^> ^d =
				gcnew System::Collections::Generic::Dictionary<System::String ^, System::Collections::Generic::List<System::String ^> ^>();
			for (iter = mappings->begin(); iter != mappings->end(); ++iter) {
				BSTR bstrClsName = (*iter).first;
				std::vector<BSTR> *v = (*iter).second;
				System::Collections::Generic::KeyValuePair<String ^, System::Collections::Generic::List<System::String ^> ^> ^p = MakeSourceMappings(bstrClsName, v);
				d->Add(p->Key, p->Value);
				SysFreeString(bstrClsName);
				std::vector<BSTR>::iterator iter;
				for (iter = v->begin(); iter != v->end(); ++iter) {
					SysFreeString((*iter));
				}
				delete (v);
			}
			delete (mappings);
			CSharp::Driver::GetDriver()->AddSourceMappings(CSharp::Driver::GetDriver()->ClassGetImage(index), d);
			Cleanup();
			result = CSharp::Driver::GetDriver()->ClassGetSourceFiles(index);
		}
	}
	if (result == nullptr) {
		return nullptr;
	} else {
		jclass javaLangStringCls = env->FindClass("java/lang/String"); 
		jobjectArray arr = env->NewObjectArray(result->Length, javaLangStringCls, NULL);
		for (int i = 0; i < result->Length; ++i) {
			env->SetObjectArrayElement(arr, i, ToJavaString(env, result[i]));
		}
		return arr;
	}
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetSourceFileName(JNIEnv *env, jobject cls, jobject intObject, jint offset) {
	System::Int32 methodIndex = ToCILInteger(UnboxInteger(env, cls, intObject));
	System::String ^name = CSharp::Driver::GetDriver()->MethodGetSourceFileName(methodIndex, offset);
	return (name == nullptr) ? nullptr : ToJavaString(env, name);
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetName(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	System::String ^name = CSharp::Driver::GetDriver()->ClassGetName(index);
	return ToJavaString(env, name);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsAbstract(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsAbstract(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsInterface(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsInterface(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsPublic(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsPublic(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsArray(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsArray(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsPointer(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsPointer(index);
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetParent(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->ClassGetParent(index));
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetDeclaredInstanceFields(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->ClassGetDeclaredInstanceFields(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetDeclaredStaticFields(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->ClassGetDeclaredStaticFields(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetDeclaredInterfaces(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->ClassGetDeclaredInterfaces(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classNotValid(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return (index == -1);
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetImage(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->ClassGetImage(index));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_findClassImpl(JNIEnv *env, jobject cls, jobject asmIntObject, jstring clsName, jstring pkgName) {
	System::Int32 asmIndex = ToCILInteger(UnboxInteger(env, cls, asmIntObject));
	System::String ^clsNameStr = ToCILString(env, clsName);
	System::String ^pkgNameStr = ToCILString(env, pkgName);
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->FindClass(asmIndex, clsNameStr, pkgNameStr));
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetName(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	System::String ^methodName = CSharp::Driver::GetDriver()->MethodGetName(index);
	return ToJavaString(env, methodName);
}

JNIEXPORT jint JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetNumberOfParameters(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodGetNumberOfParameters(index);
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetReturnType(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->MethodGetReturnType(index));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_attributeGetType(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->AttributeGetType(index));
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classGetCustomAttributes(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->ClassGetCustomAttributes(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetCustomAttributes(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Int32> ^result = CSharp::Driver::GetDriver()->MethodGetCustomAttributes(index);
	jclass javaLangIntegerCls = env->FindClass("java/lang/Integer"); 
	jobjectArray arr = env->NewObjectArray(result->Length, javaLangIntegerCls, NULL);
	for (int i = 0; i < result->Length; ++i) {
		env->SetObjectArrayElement(arr, i, BoxInteger(env, cls, ToJavaInteger(result[i])));
	}
	return arr;
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsPrimitive(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsPrimitive(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsReference(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsReference(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsWith(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsWith(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsTypeVar(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsTypeVar(index);
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetParameterType(JNIEnv *env, jobject cls, jobject intObject, jint paramIndex) {
	System::Int32 methodIndex = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->MethodGetParameterType(methodIndex, paramIndex));
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_primitiveGetNameImpl(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return ToJavaString(env, CSharp::Driver::GetDriver()->PrimitiveGetName(index));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_refGetReferrent(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->RefGetReferrent(index));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_arrayGetElement(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->ArrayGetElement(index));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_pointerGetReferrent(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->PointerGetReferrent(index));
}

JNIEXPORT jbyteArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetBytecode(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	cli::array<System::Byte> ^bytecode = CSharp::Driver::GetDriver()->MethodGetBytecode(index);
	if (bytecode == nullptr) {
		return nullptr;
	} else {
		jbyteArray bytes = env->NewByteArray(bytecode->Length);
		pin_ptr<System::Byte> rawBytecode = &bytecode[0];
		env->SetByteArrayRegion(bytes, 0, bytecode->Length, (const jbyte *) (System::Byte *) rawBytecode);
		return bytes;
	}
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_resolveMethodTokenImpl(JNIEnv *env, jobject cls, jobject intObject, jint jToken) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->ResolveMethodToken(index, jToken));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_resolveTypeTokenImpl(JNIEnv *env, jobject cls, jobject intObject, jint jToken) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->ResolveTypeToken(index, jToken));
}

//JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_resolveFieldToken(JNIEnv *env, jobject cls, jobject intObject, jint jToken) {
//	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
//	return BoxInteger(env, cls, CSharp::Driver::ResolveFieldToken(index, jToken));
//}


JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetDeclaringClassImpl(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->MethodGetDeclaringClass(index));
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsAbstract(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodIsAbstract(index);
}

//JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsClinit(JNIEnv *env, jobject cls, jobject intObject) {
//	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
//	return BoxInteger(env, cls, CSharp::Driver::MethodIsClinit(index));
//}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsFinal(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodIsFinal(index);
}

/*
 * Class:     com_ibm_wala_dotnet_loader_csharp_CSharpInterface
 * Method:    fieldIsFinal
 * Signature: (Ljava/lang/Integer;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_fieldIsFinal(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->FieldIsFinal(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_fieldIsStatic(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->FieldIsStatic(index);
}

/*
 * Class:     com_ibm_wala_dotnet_loader_csharp_CSharpInterface
 * Method:    fieldIsProtected
 * Signature: (Ljava/lang/Integer;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_fieldIsProtected(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->FieldIsProtected(index);
}

/*
 * Class:     com_ibm_wala_dotnet_loader_csharp_CSharpInterface
 * Method:    fieldIsPublic
 * Signature: (Ljava/lang/Integer;)Z
 */
JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_fieldIsPublic(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->FieldIsPublic(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsInit(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodIsInit(index);
}

JNIEXPORT jint JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_withGetNumParams(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->WithGetNumParams(index);
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_withGetParam(JNIEnv *env, jobject cls, jobject intObject, jint paramIndex) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->WithGetParam(index, paramIndex));
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsNative(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodIsNative(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsPrivate(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodIsPrivate(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsPublic(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodIsPublic(index);
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsStatic(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodIsStatic(index);
}

//JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsSynchronized(JNIEnv *env, jobject cls, jobject intObject) {
//	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
//	return BoxInteger(env, cls, CSharp::Driver::MethodIsSynchronized(index));
//}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_withGetBase(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->WithGetBase(index));
}

JNIEXPORT jint JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetHeaderSize(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodGetHeaderSize(index);
}

JNIEXPORT jobjectArray JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetHandlers(JNIEnv *env, jobject cls, jobject methodObj, jobject methodHandle) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, methodHandle));
	cli::array<CSharp::ExceptionEntry ^> ^entries = CSharp::Driver::GetDriver()->MethodGetHandlers(index);
	jclass handlerCls = env->FindClass("com/ibm/wala/dotnet/loader/CLRMethod$ExceptionEntry");
	jobjectArray data = env->NewObjectArray(entries->Length, handlerCls, NULL);
	jmethodID ctor = env->GetMethodID(handlerCls, "<init>", "(Lcom/ibm/wala/dotnet/loader/CLRMethod;Ljava/lang/String;IIIIII)V");
	for (int index = 0; index < entries->Length; ++index) {
		jstring handlerTypeStr = ToJavaString(env, entries[index]->HandlerKind);
		jobject elt = env->NewObject(handlerCls, ctor, methodObj, handlerTypeStr, entries[index]->CatchTypeToken, entries[index]->TryStart, entries[index]->TryLength, 
			entries[index]->FilterStart, entries[index]->HandlerStart, entries[index]->HandlerLength);
		env->SetObjectArrayElement(data, index, elt);
	}
	return data;
}

JNIEXPORT void JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_clearNativeCaches(JNIEnv *env, jobject cls) {
	CSharp::Driver::InvalidateDriver();
}

JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_classIsValueTypeImpl(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->ClassIsValueType(index);
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetLocalVariableTypeImpl(JNIEnv *env, jobject cls, jobject intObject, jint localIndex) {
	System::Int32 methodIndex = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->MethodGetLocalVariableType(methodIndex, localIndex));
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_resolveStringToken(JNIEnv *env, jobject cls, jobject methodHandle, jint token) {
	System::Int32 methodIndex = ToCILInteger(UnboxInteger(env, cls, methodHandle));
	return ToJavaString(env, CSharp::Driver::GetDriver()->ResolveStringToken(methodIndex, token));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_resolveFieldToken(JNIEnv *env, jobject cls, jobject methodHandle, jint token) {
	System::Int32 methodIndex = ToCILInteger(UnboxInteger(env, cls, methodHandle));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->ResolveFieldToken(methodIndex, token));
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_fieldDeclaringClassImpl(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->FieldDeclaringClass(index));
}

JNIEXPORT jstring JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_fieldGetName(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return ToJavaString(env, CSharp::Driver::GetDriver()->FieldGetName(index));
}

//JNIEXPORT jboolean JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodIsNative(JNIEnv *, jobject, jobject) {
//	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
//	return CSharp::Driver::MethodIsNative(index);
//}

void AddLineMappings(cli::array<int> ^methods, BSTR clsName) {
	for (int i = 0; i < methods->Length; ++i) {
		int mIndex = methods[i];
		if (!CSharp::Driver::GetDriver()->MethodIsAbstract(mIndex) && !CSharp::Driver::GetDriver()->MethodIsNative(mIndex)) {
			System::Collections::Generic::IDictionary<CSharp::Range ^, CSharp::LineInfo ^> ^methodMappings = gcnew System::Collections::Generic::Dictionary<CSharp::Range ^, CSharp::LineInfo ^>();
			BSTR methodName = static_cast<BSTR>(System::Runtime::InteropServices::Marshal::StringToBSTR(CSharp::Driver::GetDriver()->MethodGetName(mIndex)).ToPointer());
			std::map<range<DWORD> *,std::pair<unsigned long,BSTR> *> *table = GetLineNumbers(methodName, clsName);
			SysFreeString(methodName);
			if (table != nullptr) {
				std::map<range<DWORD> *,std::pair<unsigned long,BSTR> *>::iterator iter;
				for (iter = table->begin(); iter != table->end(); ++iter) {
					range<DWORD> *r = (*iter).first;
					std::pair<unsigned long,BSTR> *p = (*iter).second;
					System::String ^fileName = gcnew System::String(p->second);
					methodMappings->Add(
						gcnew CSharp::Range(static_cast<DWORD>(r->start()), static_cast<DWORD>(r->length())), 
						gcnew CSharp::LineInfo(fileName, static_cast<DWORD>((*p).first)));
					delete (r);
					delete (p);
				}
				CSharp::Driver::GetDriver()->AddLineMappings(mIndex, methodMappings);
				delete (table);
			}
		}
	}
}

std::vector<int> lineMappingsHistory;
JNIEXPORT jint JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetLineNumber(JNIEnv *env, jobject cls, jobject intObject, jint offset) {
	System::Int32 mIndex = ToCILInteger(UnboxInteger(env, cls, intObject));
	int result = static_cast<int>(CSharp::Driver::GetDriver()->MethodGetLineNumber(mIndex, offset));
	if (result == CSharp::Driver::INVALID_LINE_NUMBER) {
		int clsIndex = CSharp::Driver::GetDriver()->MethodGetDeclaringClass(mIndex);
		if (clsIndex != -1) {
			if (!std::binary_search(lineMappingsHistory.begin(), lineMappingsHistory.end(), clsIndex)) {
				lineMappingsHistory.push_back(clsIndex);
				int asmIndex = CSharp::Driver::GetDriver()->ClassGetImage(clsIndex);
				if (asmIndex != -1) {
					System::String ^pdbPath = CSharp::Driver::GetDriver()->GetPdbPath(asmIndex);
					if (pdbPath != nullptr) {
						System::IntPtr nativePdbPath = System::Runtime::InteropServices::Marshal::StringToBSTR(pdbPath);
						LoadDataFromPdb(static_cast<BSTR>(nativePdbPath.ToPointer()));
						System::Runtime::InteropServices::Marshal::FreeBSTR(nativePdbPath);
						System::String ^origClsName = CSharp::Driver::GetDriver()->ClassGetName(clsIndex)->Replace('/', '.');
						System::IntPtr nativeClsName = System::Runtime::InteropServices::Marshal::StringToBSTR(origClsName);
						cli::array<int> ^instanceMethods = CSharp::Driver::GetDriver()->ClassGetDeclaredInstanceMethods(clsIndex);
						AddLineMappings(instanceMethods, static_cast<BSTR>(nativeClsName.ToPointer()));
						cli::array<int> ^staticMethods = CSharp::Driver::GetDriver()->ClassGetDeclaredStaticMethods(clsIndex);
						AddLineMappings(staticMethods, static_cast<BSTR>(nativeClsName.ToPointer()));
						System::Runtime::InteropServices::Marshal::FreeBSTR(nativeClsName);
						Cleanup();
						result = static_cast<int>(CSharp::Driver::GetDriver()->MethodGetLineNumber(mIndex, offset));
					}
				}
			}
		}
	}
	return result;
}

JNIEXPORT jobject JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_fieldGetType(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return BoxInteger(env, cls, CSharp::Driver::GetDriver()->FieldGetType(index));
}

JNIEXPORT jint JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetMaxStackHeight(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodGetMaxStackHeight(index);
}

JNIEXPORT jint JNICALL Java_com_ibm_wala_dotnet_loader_csharp_CSharpInterface_methodGetMaxLocals(JNIEnv *env, jobject cls, jobject intObject) {
	System::Int32 index = ToCILInteger(UnboxInteger(env, cls, intObject));
	return CSharp::Driver::GetDriver()->MethodGetMaxLocals(index);
}