#ifndef __TWO_WAY_MAP
#define __TWO_WAY_MAP

#include <map>

using namespace std;

template<class A, class B>
struct two_way_map {
private: 
  map<A, B> left;
  map<B, A> right;

public:
  struct _b_key {
    B key;
    two_way_map &map;

    _b_key(B b, two_way_map& map) : key(b), map(map) {
    }

    _b_key operator =(A a) {
      map.left[a] = key;
      map.right[key] = a;
      return *this;
    }

    operator A() {
      return map.right[key];
    }
  };

  _b_key operator[](B b) {
    return _b_key(b, *this);
  }

  bool contains(B b) {
    return right.count(b) > 0;
  }

  struct _a_key {
    A key;
    two_way_map &map;

    _a_key(A a, two_way_map& map) : key(a), map(map) {
    }

    _a_key operator =(B b) {
      map.left[key] = b;
      map.right[b] = key;
      return *this;
    }

    operator B() {
      return map.left[key];
    }
  };

  _a_key operator[](A a) {
    return _a_key(a, *this);
  }

  bool contains(A a) {
    return left.count(a) > 0;
  }
};

#endif // __TWO_WAY_MAP
