using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection.Emit;
using System.Reflection;

namespace CSharp
{
    class InlineFieldInstruction : ILInstruction
    {
        private readonly Int32 fieldToken;
        private readonly System.Reflection.FieldInfo field;

        public InlineFieldInstruction(MethodBase enclosingMethod, OpCode opcode, Int32 offset, Int32 fieldToken)
            : base(enclosingMethod, opcode, offset)
        {
            this.fieldToken = fieldToken;
            this.field      = enclosingMethod.Module.ResolveField(fieldToken);
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder(base.ToString());
            sb.Append('\t');
            sb.Append(field);
            return sb.ToString();
        }

        public System.Reflection.FieldInfo Field
        {
            get { return this.field; }
        } 

        public Int32 FieldToken
        {
            get { return this.fieldToken; }
        } 
    }
}
