using System;
using System.Collections.Generic;
using System.Text;

namespace CSharpImpl
{
    public class Range : MarshalByRefObject
    {
        private readonly ulong start, length;

        public Range(ulong start, ulong length)
        {
            this.start  = start;
            this.length = length;
        }

        public ulong Start
        {
            get
            {
                return start;
            }
        }

        public ulong Length
        {
            get
            {
                return length;
            }
        }

        public bool Contains(ulong offset)
        {
            return ((offset >= start) && ((offset - start) < length));
        }

        public override int GetHashCode()
        {
            return (int)((start * 2) + (length * 4));
        }

        public override bool Equals(object obj)
        {
            if (obj is Range)
            {
                Range other = obj as Range;
                return ((other.start == start) && (other.length == length)); 
            }
            return false;
        }
    }
}
