using System;
using System.Collections;
using System.Text;

namespace CSharpImpl
{
    public class Vector<T> : System.Collections.Generic.IEnumerable<T>
    {
        #region Fields
        private System.Collections.Generic.List<T> storage;
        #endregion

        #region CTOR
        public Vector(int initialCapacity)
        {
            this.storage = new System.Collections.Generic.List<T>(initialCapacity);
        }
        #endregion

        #region Indexers
        public T this[int index]
        {
            get
            {
                return storage[index];
            }
        }
        #endregion

        #region Properties
        public int Count
        {
            get
            {
                return storage.Count;
            }
        }
        #endregion

        #region Methods
        public void AddAll(System.Collections.Generic.IEnumerable<T> collection)
        {
            foreach (T t in collection)
            {
                Add(t);
            }
        }

        public int Add(T element)
        {
            storage.Add(element);
            return storage.IndexOf(element);
        }
        #endregion

        #region IEnumerable<T> Members
        public System.Collections.Generic.IEnumerator<T> GetEnumerator()
        {
            return storage.GetEnumerator();
        }
        #endregion

        #region IEnumerable Members
        IEnumerator IEnumerable.GetEnumerator()
        {
            return storage.GetEnumerator();
        }
        #endregion
    }
}
