/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.common.scm;

import com.hcl.appscan.common.scm.IScmProvider;
import com.hcl.appscan.common.scm.NullScmProvider;
import com.hcl.appscan.common.scm.ScmFactory;
import com.hcl.appscan.common.scm.ScmSettingsWriter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.logging.Message;
import java.io.File;
import java.io.IOException;

public class ScmUtil {
    private static IScmProvider m_provider = null;

    public static String getCommitBaseUrl() {
        return m_provider == null ? null : m_provider.getCommitBaseUrl();
    }

    public static String getRepositoryRelativePath(String path) {
        return m_provider == null ? path : m_provider.getRepositoryRelativePath(path);
    }

    public static String getRepositoryUrl() {
        return m_provider == null ? null : m_provider.getRepositoryUrl();
    }

    public static String getCommitId() {
        return m_provider == null ? null : m_provider.getCommitId();
    }

    public static String getBranchName() {
        return m_provider == null ? null : m_provider.getBranchName();
    }

    public static String getScmName() {
        return m_provider == null ? null : m_provider.getName();
    }

    public static void writeScmSettings(File settingsFile) throws IOException {
        if (m_provider != null) {
            new ScmSettingsWriter(m_provider, settingsFile).write();
        }
    }

    public static void initializeFromSettings(File settingsFile) throws IOException {
        m_provider = ScmFactory.getScmProviderFromSettingsFile(settingsFile);
    }

    public static void initialize(File directory, IProgress progress) {
        IScmProvider provider = ScmFactory.getScmProviderForDirectory(directory, progress);
        if (m_provider == null || !(provider instanceof NullScmProvider)) {
            m_provider = provider;
        }
        if (ScmUtil.haveValidProvider()) {
            progress.setStatus(new Message(1, Messages.getMessage("scm.repo.found", m_provider.getName(), m_provider.getRepositoryUrl(), m_provider.getBranchName(), m_provider.getCommitId())));
        }
    }

    private static boolean haveValidProvider() {
        return m_provider != null && !(m_provider instanceof NullScmProvider);
    }
}

