/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public final class EngineMessage {
    private Map<String, String> m_attributeMap;
    private String m_text = null;

    public EngineMessage(Map<String, String> attributes, String text) {
        this.m_attributeMap = attributes;
        this.m_text = text;
    }

    public int getSeverity() {
        return Integer.parseInt(this.m_attributeMap.get("message_severity"));
    }

    public Date getTimestamp() {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse(this.m_attributeMap.get("date_time"));
        }
        catch (ParseException e) {
            System.out.println(e);
        }
        return date;
    }

    public String getText() {
        return this.m_text;
    }

    public String getType() {
        return this.m_attributeMap.get("message_type");
    }

    public int getLine() {
        return Integer.parseInt(this.m_attributeMap.get("line_number"));
    }

    public String getMissingClassName() {
        return this.m_attributeMap.get("missing_classname");
    }

    public String getAttributeValue(String attr) {
        return this.m_attributeMap.get(attr);
    }
}

