/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.event.IScanChangedListener;
import com.ibm.appscan.common.model.event.IScanErrorListener;
import com.ibm.appscan.internal.common.model.Scan;
import com.ibm.appscan.internal.common.model.ScanFile;
import java.io.File;
import java.util.ServiceLoader;

public class ScanModelFactory {
    public static IScan newScan() {
        Scan scan = new Scan();
        for (IScanChangedListener iScanChangedListener : ServiceLoader.load(IScanChangedListener.class)) {
            scan.addScanChangedListener(iScanChangedListener);
        }
        for (IScanErrorListener iScanErrorListener : ServiceLoader.load(IScanErrorListener.class)) {
            scan.addScanErrorListener(iScanErrorListener);
        }
        return scan;
    }

    public static IScanFile newScanFile(File file) {
        return new ScanFile(file);
    }

    public static IScanFile newScanFile(String filePath) {
        return new ScanFile(filePath);
    }

    public static IScanFile newScanFile(File file, String checksum) {
        return new ScanFile(file, checksum);
    }
}

