/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.xml;

import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class XMLStreamReader
implements EventFilter {
    private XMLInputFactory m_factory = XMLInputFactory.newInstance();

    protected XMLStreamReader() {
        this.m_factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        this.m_factory.setProperty("javax.xml.stream.supportDTD", false);
        this.configureFactory(this.m_factory);
    }

    protected void configureFactory(XMLInputFactory factory) {
    }

    @Override
    public final boolean accept(XMLEvent event) {
        return event.isStartElement() || event.isEndElement();
    }

    protected final String getAttribute(StartElement element, String name) {
        Attribute attribute = element.getAttributeByName(new QName(name));
        return attribute == null ? null : attribute.getValue();
    }

    protected boolean process(StartElement element) {
        return true;
    }

    protected boolean process(StartElement element, ElementValue value) throws XMLStreamException {
        return this.process(element);
    }

    protected boolean process(EndElement element) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(InputStream stream) throws XMLStreamException {
        try (XMLEventReader xmlReader = null;){
            xmlReader = this.getReader(stream, this.m_factory);
            ElementValue value = new ElementValue(xmlReader);
            while (xmlReader.hasNext()) {
                boolean cont;
                XMLEvent event = xmlReader.nextEvent();
                boolean bl = cont = event.isStartElement() ? this.process(event.asStartElement(), value) : this.process(event.asEndElement());
                if (cont) continue;
                return;
            }
        }
    }

    protected XMLEventReader getReader(InputStream stream, XMLInputFactory factory) throws XMLStreamException {
        return factory.createFilteredReader(factory.createXMLEventReader(stream, "UTF-8"), this);
    }

    public class ElementValue {
        private XMLEventReader m_reader;

        private ElementValue(XMLEventReader reader) {
            this.m_reader = reader;
        }

        public String getText() throws XMLStreamException {
            return this.m_reader.getElementText();
        }
    }
}

