/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.ibm.appscan.common.model.IBuildInfoManager;
import com.ibm.appscan.internal.common.model.BuildInfo;
import com.ibm.appscan.internal.common.model.ScanTarget;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class BuildInfoManager
implements IBuildInfoManager {
    BuildInfo m_buildInfo = new BuildInfo();
    private ScanTarget m_target;
    private Map<String, String> m_liveMap;
    private Map<String, String> m_map;

    BuildInfoManager(ScanTarget target) {
        this.m_target = target;
        this.m_liveMap = target.getScan().getCustomTargetInfo(target.getPath()).getBuildInfos();
        this.m_map = new Hashtable<String, String>(this.m_liveMap);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        Hashtable<String, String> mergedMap = new Hashtable<String, String>(this.m_buildInfo.m_map);
        mergedMap.putAll(this.m_map);
        return mergedMap.entrySet().iterator();
    }

    @Override
    public void setProperty(String key, String value) {
        this.m_map.put(key, value);
    }

    @Override
    public String getProperty(String key) {
        return this.m_map.containsKey(key) ? this.m_map.get(key) : this.m_buildInfo.getProperty(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.m_map.containsKey(key) || this.m_buildInfo.containsKey(key);
    }

    @Override
    public boolean isUserEdited(String key) {
        return this.m_map.containsKey(key);
    }

    @Override
    public boolean isUserDefined(String key) {
        return this.m_map.containsKey(key) && !this.m_buildInfo.containsKey(key);
    }

    @Override
    public String getDiscoveredProperty(String key) {
        return this.m_buildInfo.getProperty(key);
    }

    @Override
    public void restoreDiscoveredProperty(String key) {
        this.m_map.remove(key);
    }

    @Override
    public void restoreDefaults() {
        this.m_map.clear();
    }

    @Override
    public void commit(boolean commit) {
        if (commit) {
            boolean changed = false;
            Iterator<Map.Entry<String, String>> iter = this.m_liveMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String key = entry.getKey();
                if (this.m_map.containsKey(key)) {
                    if (entry.getValue().equals(this.m_map.get(key))) continue;
                    changed = true;
                    continue;
                }
                iter.remove();
                changed = true;
            }
            if (changed || this.m_liveMap.size() < this.m_map.size()) {
                this.m_liveMap.putAll(this.m_map);
                this.m_target.setValid(false);
                this.m_target.getScan().fireScanTargetModified(this.m_target);
            }
        } else {
            this.m_map.clear();
            this.m_map.putAll(this.m_liveMap);
        }
    }
}

