/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.ibm.appscan.common.error.IErrorManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.internal.common.model.IErrorObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ErrorManager
implements IErrorManager,
IErrorObserver {
    private IScanTarget m_target;
    IErrorObserver m_parent = null;
    private List<Message> m_errors = new ArrayList<Message>();
    private long childErrorCount = 0L;

    ErrorManager(IScanTarget target, IErrorObserver parent) {
        this.m_target = target;
        this.m_parent = parent;
    }

    @Override
    public void notifyIncrement(IScanTarget target) {
        ++this.childErrorCount;
        this.m_parent.notifyIncrement(this.m_target);
    }

    private void logError(Message error) {
        if (this.m_errors.add(error)) {
            this.m_parent.notifyIncrement(this.m_target);
            this.m_target.getScan().getLogManager().log(error);
        }
    }

    @Override
    public void reportError(String error) {
        this.reportErrorWithHelp(error, null);
    }

    @Override
    public void reportError(String error, String buildInfoKey) {
        this.reportErrorWithHelp(error, buildInfoKey, null);
    }

    @Override
    public void reportError(String error, File file) {
        this.reportErrorWithHelp(error, file, null);
    }

    @Override
    public void reportError(String error, File file, int line) {
        this.reportErrorWithHelp(error, file, line, null);
    }

    @Override
    public void reportError(String error, Throwable throwable) {
        this.reportErrorWithHelp(error, throwable, null);
    }

    @Override
    public void reportError(String error, String buildInfoKey, File file, int line, Throwable throwable) {
        this.reportErrorWithHelp(error, buildInfoKey, file, line, throwable, null);
    }

    @Override
    public void reportErrorWithHelp(String error, String helpID) {
        this.reportErrorWithHelp(error, null, null, 0, null, helpID);
    }

    @Override
    public void reportErrorWithHelp(String error, String buildInfoKey, String helpID) {
        this.reportErrorWithHelp(error, buildInfoKey, null, 0, null, helpID);
    }

    @Override
    public void reportErrorWithHelp(String error, File file, String helpID) {
        this.reportErrorWithHelp(error, null, file, 0, null, helpID);
    }

    @Override
    public void reportErrorWithHelp(String error, File file, int line, String helpID) {
        this.reportErrorWithHelp(error, null, file, line, null, helpID);
    }

    @Override
    public void reportErrorWithHelp(String error, Throwable throwable, String helpID) {
        this.reportErrorWithHelp(error, null, null, 0, throwable, helpID);
    }

    @Override
    public void reportErrorWithHelp(String error, String buildInfoKey, File file, int line, Throwable throwable, String helpID) {
        Message message;
        Message message2 = message = new Message(error, throwable);
        message2.getClass();
        message.setMessageSource(new Message.MessageSource(message2, this.m_target.getPath(), buildInfoKey, file == null ? null : file.getPath(), line));
        message.setHelpID(helpID);
        this.logError(message);
    }

    @Override
    public void notifyDecrement(IScanTarget target, int count) {
        assert (this.childErrorCount >= (long)count);
        this.childErrorCount -= (long)count;
        this.m_parent.notifyDecrement(this.m_target, count);
    }

    void clearErrors() {
        int errors = this.m_errors.size();
        if (errors > 0) {
            this.m_errors.clear();
            this.m_parent.notifyDecrement(this.m_target, errors);
        }
    }

    @Override
    public Collection<Message> getErrors() {
        return Collections.unmodifiableList(this.m_errors);
    }

    @Override
    public long getTotalErrors() {
        return (long)this.m_errors.size() + this.childErrorCount;
    }
}

