/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.java.translator;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.java.translator.RepositoryUtil;
import com.ibm.wala.stringAnalysis.translator.DefUseChainBasedComposer;
import com.ibm.wala.stringAnalysis.translator.IInvocationSymbolComposer;
import com.ibm.wala.stringAnalysis.translator.IRegexParser;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.translator.cfg.CFGTranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Base64Encode;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.BooleanValueOf;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.CharAt;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.CharReplace;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Concatenate;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Contains;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.CopyValueOf;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Delete;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Empty;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.FileJoin;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.GetAbsoluteFile;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.GetFileName;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.GetProperty;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Identity;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Insert;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IntRange;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsDigit;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsLetter;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsLetterOrDigit;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsNotDigit;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsNotLetter;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsNotLetterOrDigit;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsNotSpaceChar;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsNotWhitespace;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsSpaceChar;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.IsWhitespace;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.JavaBridge;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.JavaMatcherGroup;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.JavaMatcherMatches;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.JavaMatcherNotMatches;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.JavaMatcherReplaceAll;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.JavaPatternMatcher;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NetUrlDecoder;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NetUrlEncoder;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NotContains;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NotRegexMatches;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NotStringEquals;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NumToByte;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NumToDouble;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NumToFloat;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NumToInt;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NumToLong;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.NumToShort;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ParseByte;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ParseChar;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ParseDouble;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ParseFloat;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ParseInt;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ParseLong;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ParseShort;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ReadLine;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.RegexMatches;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Replace;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.RetAnyString;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.RetInteger;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.RetIntegerWithNegativeValue;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringConstIndexOf;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringEquals;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringIndexOf;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringLengthCheck;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringMapContainsKey;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringMapGet;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringMapInit;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringMapPut;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Strreplace;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Strrev;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Strsplit;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Substring;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.SubstringByIndex;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ToCardinalNumberString;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ToLowerCase;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ToString;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.ToUpperCase;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Trim;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class JavaCFGTranslatorRepository
extends CFGTranslatorRepository {
    private static String[] defaultStringClasses = new String[]{"Ljava/lang/String", "Ljava/lang/StringBuffer", "Ljava/lang/StringBuilder", "Ljava/io/File", "Ljava/io/FileInputStream", "Ljava/io/FileOutputStream", "Ljava/lang/System", "Ljava/net/URL", "Ljava/net/URI", "Ljava/util/regex/Pattern", "Ljava/util/regex/Matcher", "Ljava/util/Map", "Ljava/util/HashMap", "Ljava/util/TreeMap"};
    private ClassLoader loader = null;
    private Set<String> stringClasses;

    public JavaCFGTranslatorRepository(ClassLoader loader) {
        this.loader = loader;
        this.stringClasses = new HashSet<String>();
        this.initTranslators();
        this.initMapTranslators();
        this.initStringClasses();
        this.initComposers();
    }

    public JavaCFGTranslatorRepository() {
        this(null);
    }

    public void initComposers() {
        this.putComposer("java.lang.String.substring(II)Ljava/lang/String;", (IInvocationSymbolComposer)new DefUseChainBasedComposer(2, Arrays.asList("java.lang.String.indexOf(Ljava/lang/String;)I", "java.lang.String.indexOf(Ljava/lang/String;I)I", "java.lang.String.indexOf(C)I", "java.lang.String.indexOf(CI)I")));
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    protected void initTranslators() {
        RetInteger retInt = new RetInteger();
        RetIntegerWithNegativeValue retIntWithNegVal = new RetIntegerWithNegativeValue();
        Concatenate concat = new Concatenate(-1);
        Substring substring = new Substring(0, 1);
        CharAt charAt = new CharAt(0);
        ToString doubleToStringWithArg = new ToString(0, JavaPrimitiveType.DOUBLE);
        ToString floatToStringWithArg = new ToString(0, JavaPrimitiveType.FLOAT);
        ToString intToStringWithArg = new ToString(0, JavaPrimitiveType.INT);
        ToString longToStringWithArg = new ToString(0, JavaPrimitiveType.LONG);
        ToString shortToStringWithArg = new ToString(0, JavaPrimitiveType.SHORT);
        ToString booleanToString = new ToString(JavaPrimitiveType.BOOLEAN);
        ToString doubleToString = new ToString(JavaPrimitiveType.DOUBLE);
        ToString floatToString = new ToString(JavaPrimitiveType.FLOAT);
        ToString shortToString = new ToString(JavaPrimitiveType.SHORT);
        Concatenate booleanConcat = new Concatenate(-1, new SignatureSymbol("java.lang.Boolean.toString()Ljava/lang/String;"));
        Concatenate charConcat = new Concatenate(-1, new SignatureSymbol("java.lang.Character.toString()Ljava/lang/String;"));
        Concatenate doubleConcat = new Concatenate(-1, new SignatureSymbol("java.lang.Double.toString()Ljava/lang/String;"));
        Concatenate floatConcat = new Concatenate(-1, new SignatureSymbol("java.lang.Float.toString()Ljava/lang/String;"));
        Concatenate intConcat = new Concatenate(-1, new SignatureSymbol("java.lang.Integer.toString()Ljava/lang/String;"));
        Concatenate longConcat = new Concatenate(-1, new SignatureSymbol("java.lang.Long.toString()Ljava/lang/String;"));
        Insert booleanInsert = new Insert(JavaPrimitiveType.BOOLEAN);
        Insert charInsert = new Insert(JavaPrimitiveType.CHAR);
        Insert doubleInsert = new Insert(JavaPrimitiveType.DOUBLE);
        Insert floatInsert = new Insert(JavaPrimitiveType.FLOAT);
        Insert intInsert = new Insert(JavaPrimitiveType.INT);
        Insert longInsert = new Insert(JavaPrimitiveType.LONG);
        RetAnyString retAny = new RetAnyString();
        this.translatorMap.put("op(add)", retAny);
        this.translatorMap.put("java.lang.Object.toString()Ljava/lang/String;", retAny);
        this.translatorMap.put("java.util.Arrays.toString([B)Ljava/lang/String;", retAny);
        this.translatorMap.put("java.lang.String.<init>()V", new Empty());
        this.translatorMap.put("java.lang.String.<init>(Ljava/lang/String;)V", new Identity(0));
        this.translatorMap.put("java.lang.String.<init>(Ljava/lang/String;,Ljava/lang/String;)V", new Identity(0));
        this.translatorMap.put("java.lang.String.substring(II)Ljava/lang/String;", substring);
        this.translatorMap.put("java.lang.String.substring(I)Ljava/lang/String;", substring);
        this.translatorMap.put("java.lang.String.substring(II)Ljava/lang/String;java.lang.String.indexOf(Ljava/lang/String;)I", new SubstringByIndex(0, 1, 2));
        this.translatorMap.put("java.lang.String.toUpperCase()Ljava/lang/String;", new ToUpperCase());
        this.translatorMap.put("java.lang.String.toLowerCase()Ljava/lang/String;", new ToLowerCase());
        this.translatorMap.put("java.lang.String.concat(Ljava/lang/String;)Ljava/lang/String;", concat);
        this.translatorMap.put("java.lang.String.trim()Ljava/lang/String;", new Trim());
        this.translatorMap.put("java.lang.String.charAt(I)C", charAt);
        this.translatorMap.put("java.lang.String.replace(CC)Ljava/lang/String;", new CharReplace(0, 1));
        this.translatorMap.put("java.lang.String.replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;", new Strreplace(0, 1, false));
        this.translatorMap.put("java.lang.String.replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", new Strreplace(0, 1, true));
        this.translatorMap.put("java.lang.String.toCharArray()[C", new Strsplit(1));
        this.translatorMap.put("java.lang.String.compareTo(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.indexOf(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.indexOf(I)I", retIntWithNegVal);
        this.translatorMap.put("#const.java.lang.String.indexOf(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("#const.java.lang.String.indexOf(I)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.indexOf(II)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.indexOf(Ljava/lang/String;I)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.lastIndexOf(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.lastIndexOf(I)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.lastIndexOf(II)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.lastIndexOf(Ljava/lang/String;I)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.String.toString()Ljava/lang/String;", new ToString());
        this.translatorMap.put("java.lang.String.copyValueOf([C)Ljava/lang/String;", new CopyValueOf(0));
        this.translatorMap.put("java.lang.String.valueOf(Z)Ljava/lang/String;", new ToString(0, JavaPrimitiveType.BOOLEAN));
        this.translatorMap.put("java.lang.String.valueOf(C)Ljava/lang/String;", new ToString(0, JavaPrimitiveType.CHAR));
        this.translatorMap.put("java.lang.String.valueOf([C)Ljava/lang/String;", new CopyValueOf(0));
        this.translatorMap.put("java.lang.String.valueOf(D)Ljava/lang/String;", doubleToStringWithArg);
        this.translatorMap.put("java.lang.String.valueOf(F)Ljava/lang/String;", floatToStringWithArg);
        this.translatorMap.put("java.lang.String.valueOf(I)Ljava/lang/String;", intToStringWithArg);
        this.translatorMap.put("java.lang.String.valueOf(J)Ljava/lang/String;", longToStringWithArg);
        this.translatorMap.put("java.lang.String.valueOf(Ljava/lang/Object;)Ljava/lang/String;", new ToString(0));
        this.translatorMap.put("java.lang.StringBuffer.<init>()V", new Empty());
        this.translatorMap.put("java.lang.StringBuffer.<init>(I)V", new Empty());
        this.translatorMap.put("java.lang.StringBuffer.<init>(Ljava/lang/String;)V", new Identity(0));
        this.translatorMap.put("java.lang.StringBuffer.<init>(Ljava/lang/StringBuffer;)V", new Identity(0));
        this.translatorMap.put("java.lang.StringBuffer.<init>(Ljava/lang/CharSequence;)V", new Identity(0));
        this.translatorMap.put("java.lang.StringBuffer.indexOf(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.StringBuffer.lastIndexOf(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.StringBuffer.codePointAt(I)I", retInt);
        this.translatorMap.put("java.lang.StringBuffer.codePointBefore(I)I", retInt);
        this.translatorMap.put("java.lang.StringBuffer.codePointCount(II)I", retInt);
        this.translatorMap.put("java.lang.StringBuffer.charAt(I)C", charAt);
        this.translatorMap.put("java.lang.StringBuffer.substring(II)Ljava/lang/String;", substring);
        this.translatorMap.put("java.lang.StringBuffer.substring(I)Ljava/lang/String;", substring);
        this.translatorMap.put("java.lang.StringBuffer.toString()Ljava/lang/String;", new ToString());
        this.translatorMap.put("java.lang.StringBuffer.append(Ljava/lang/String;)Ljava/lang/StringBuffer;", concat);
        this.translatorMap.put("java.lang.StringBuffer.append(Z)Ljava/lang/StringBuffer;", booleanConcat);
        this.translatorMap.put("java.lang.StringBuffer.append(C)Ljava/lang/StringBuffer;", charConcat);
        this.translatorMap.put("java.lang.StringBuffer.append(D)Ljava/lang/StringBuffer;", doubleConcat);
        this.translatorMap.put("java.lang.StringBuffer.append(F)Ljava/lang/StringBuffer;", floatConcat);
        this.translatorMap.put("java.lang.StringBuffer.append(I)Ljava/lang/StringBuffer;", intConcat);
        this.translatorMap.put("java.lang.StringBuffer.append(J)Ljava/lang/StringBuffer;", longConcat);
        this.translatorMap.put("java.lang.StringBuffer.append(Ljava/lang/StringBuffer;)Ljava/lang/StringBuffer;", concat);
        this.translatorMap.put("java.lang.StringBuffer.delete(II)Ljava/lang/StringBuffer;", new Delete(0, 1));
        this.translatorMap.put("java.lang.StringBuffer.deleteCharAt(I)Ljava/lang/StringBuffer;", new Delete(0, 1));
        this.translatorMap.put("java.lang.StringBuffer.insert(ILjava/lang/String;)Ljava/lang/StringBuffer;", new Insert());
        this.translatorMap.put("java.lang.StringBuffer.insert(IZ)Ljava/lang/StringBuffer;", booleanInsert);
        this.translatorMap.put("java.lang.StringBuffer.insert(IC)Ljava/lang/StringBuffer;", charInsert);
        this.translatorMap.put("java.lang.StringBuffer.insert(ID)Ljava/lang/StringBuffer;", doubleInsert);
        this.translatorMap.put("java.lang.StringBuffer.insert(IF)Ljava/lang/StringBuffer;", floatInsert);
        this.translatorMap.put("java.lang.StringBuffer.insert(II)Ljava/lang/StringBuffer;", intInsert);
        this.translatorMap.put("java.lang.StringBuffer.insert(IJ)Ljava/lang/StringBuffer;", longInsert);
        this.translatorMap.put("java.lang.StringBuffer.replace(IILjava/lang/String;)Ljava/lang/StringBuffer;", new Replace(0, 1, 2));
        this.translatorMap.put("java.lang.StringBuffer.reverse()Ljava/lang/StringBuffer;", new Strrev());
        this.translatorMap.put("java.lang.StringBuilder.<init>()V", new Empty());
        this.translatorMap.put("java.lang.StringBuilder.<init>(I)V", new Empty());
        this.translatorMap.put("java.lang.StringBuilder.<init>(Ljava/lang/String;)V", new Identity(0));
        this.translatorMap.put("java.lang.StringBuilder.<init>(Ljava/lang/StringBuilder;)V", new Identity(0));
        this.translatorMap.put("java.lang.StringBuilder.<init>(Ljava/lang/CharSequence;)V", new Identity(0));
        this.translatorMap.put("java.lang.StringBuilder.indexOf(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.StringBuilder.lastIndexOf(Ljava/lang/String;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.StringBuilder.codePointAt(I)I", retInt);
        this.translatorMap.put("java.lang.StringBuilder.codePointBefore(I)I", retInt);
        this.translatorMap.put("java.lang.StringBuilder.codePointCount(II)I", retInt);
        this.translatorMap.put("java.lang.StringBuilder.charAt(I)C", charAt);
        this.translatorMap.put("java.lang.StringBuilder.substring(II)Ljava/lang/String;", substring);
        this.translatorMap.put("java.lang.StringBuilder.substring(I)Ljava/lang/String;", substring);
        this.translatorMap.put("java.lang.StringBuilder.toString()Ljava/lang/String;", new ToString());
        this.translatorMap.put("java.lang.StringBuilder.append(Ljava/lang/String;)Ljava/lang/StringBuilder;", concat);
        this.translatorMap.put("java.lang.StringBuilder.append(Z)Ljava/lang/StringBuilder;", booleanConcat);
        this.translatorMap.put("java.lang.StringBuilder.append(C)Ljava/lang/StringBuilder;", charConcat);
        this.translatorMap.put("java.lang.StringBuilder.append(D)Ljava/lang/StringBuilder;", doubleConcat);
        this.translatorMap.put("java.lang.StringBuilder.append(F)Ljava/lang/StringBuilder;", floatConcat);
        this.translatorMap.put("java.lang.StringBuilder.append(I)Ljava/lang/StringBuilder;", intConcat);
        this.translatorMap.put("java.lang.StringBuilder.append(J)Ljava/lang/StringBuilder;", longConcat);
        this.translatorMap.put("java.lang.StringBuilder.append(Ljava/lang/StringBuilder;)Ljava/lang/StringBuilder;", concat);
        this.translatorMap.put("java.lang.StringBuilder.delete(II)Ljava/lang/StringBuilder;", new Delete(0, 1));
        this.translatorMap.put("java.lang.StringBuilder.deleteCharAt(I)Ljava/lang/StringBuilder;", new Delete(0, 1));
        this.translatorMap.put("java.lang.StringBuilder.insert(ILjava/lang/String;)Ljava/lang/StringBuilder;", new Insert());
        this.translatorMap.put("java.lang.StringBuilder.insert(IZ)Ljava/lang/StringBuilder;", booleanInsert);
        this.translatorMap.put("java.lang.StringBuilder.insert(IC)Ljava/lang/StringBuilder;", charInsert);
        this.translatorMap.put("java.lang.StringBuilder.insert(ID)Ljava/lang/StringBuilder;", doubleInsert);
        this.translatorMap.put("java.lang.StringBuilder.insert(IF)Ljava/lang/StringBuilder;", floatInsert);
        this.translatorMap.put("java.lang.StringBuilder.insert(II)Ljava/lang/StringBuilder;", intInsert);
        this.translatorMap.put("java.lang.StringBuilder.insert(IJ)Ljava/lang/StringBuilder;", longInsert);
        this.translatorMap.put("java.lang.StringBuilder.replace(IILjava/lang/String;)Ljava/lang/StringBuilder;", new Replace(0, 1, 2));
        this.translatorMap.put("java.lang.StringBuilder.reverse()Ljava/lang/StringBuilder;", new Strrev());
        this.translatorMap.put("java.lang.Character.charCount(I)I", retInt);
        this.translatorMap.put("java.lang.Character.compareTo(Ljava/lang/Character;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Character.charValue()C", new ParseChar());
        this.translatorMap.put("java.lang.Character.toString()Ljava/lang/String;", new ToString(JavaPrimitiveType.CHAR));
        this.translatorMap.put("java.lang.Character.toString(C)Ljava/lang/String;", new ToString(0, JavaPrimitiveType.CHAR));
        this.translatorMap.put("java.lang.Character.valueOf(C)Ljava/lang/Character;", new ToString(0, JavaPrimitiveType.CHAR));
        this.translatorMap.put("java.lang.Character.toUpperCase(C)C", new ToUpperCase(0));
        this.translatorMap.put("java.lang.Character.toLowerCase(C)C", new ToLowerCase(0));
        this.translatorMap.put("java.lang.Boolean.compareTo(Ljava/lang/Boolean;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Boolean.booleanValue()Z", booleanToString);
        this.translatorMap.put("java.lang.Boolean.toString()Ljava/lang/String;", booleanToString);
        this.translatorMap.put("java.lang.Boolean.toString(Z)Ljava/lang/String;", new ToString(0, JavaPrimitiveType.BOOLEAN));
        this.translatorMap.put("java.lang.Boolean.valueOf(Z)Ljava/lang/Boolean;", new ToString(0, JavaPrimitiveType.BOOLEAN));
        this.translatorMap.put("java.lang.Boolean.valueOf(Ljava/lang/String;)Ljava/lang/Boolean;", new BooleanValueOf(0));
        this.translatorMap.put("java.lang.Integer.compareTo(Ljava/lang/Integer;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Integer.intValue()I", new NumToInt());
        this.translatorMap.put("java.lang.Integer.parseInt(Ljava/lang/String;)I", new ParseInt(0));
        this.translatorMap.put("java.lang.Integer.doubleValue()D", new NumToDouble());
        this.translatorMap.put("java.lang.Integer.floatValue()F", new NumToFloat());
        this.translatorMap.put("java.lang.Integer.longValue()J", new NumToInt());
        this.translatorMap.put("java.lang.Integer.byteValue()B", new NumToByte());
        this.translatorMap.put("java.lang.Integer.shortValue()S", new NumToShort());
        this.translatorMap.put("java.lang.Integer.toBinaryString(I)Ljava/lang/String;", new ToCardinalNumberString(0, 1, JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Integer.toHexString(I)Ljava/lang/String;", new ToCardinalNumberString(0, 2, JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Integer.toOctalString(I)Ljava/lang/String;", new ToCardinalNumberString(0, 3, JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Integer.toString()Ljava/lang/String;", new ToString(JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Integer.toString(I)Ljava/lang/String;", new ToString(0, JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Integer.valueOf(I)Ljava/lang/Integer;", new ParseInt(0));
        this.translatorMap.put("java.lang.Integer.valueOf(Ljava/lang/String;)Ljava/lang/Integer;", new ParseInt(0));
        this.translatorMap.put("java.lang.Long.compareTo(Ljava/lang/Long;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Long.intValue()I", new NumToInt());
        this.translatorMap.put("java.lang.Long.parseLong(Ljava/lang/String;)J", new ParseLong(0));
        this.translatorMap.put("java.lang.Long.doubleValue()D", new NumToDouble());
        this.translatorMap.put("java.lang.Long.floatValue()F", new NumToFloat());
        this.translatorMap.put("java.lang.Long.longValue()J", new NumToLong());
        this.translatorMap.put("java.lang.Long.byteValue()B", new NumToByte());
        this.translatorMap.put("java.lang.Long.shortValue()S", new NumToShort());
        this.translatorMap.put("java.lang.Long.toBinaryString(J)Ljava/lang/String;", new ToCardinalNumberString(0, 1, JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Long.toHexString(J)Ljava/lang/String;", new ToCardinalNumberString(0, 2, JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Long.toOctalString(J)Ljava/lang/String;", new ToCardinalNumberString(0, 3, JavaPrimitiveType.INT));
        this.translatorMap.put("java.lang.Long.toString()Ljava/lang/String;", new ToString(JavaPrimitiveType.LONG));
        this.translatorMap.put("java.lang.Long.toString(J)Ljava/lang/String;", new ToString(0, JavaPrimitiveType.LONG));
        this.translatorMap.put("java.lang.Long.valueOf(J)Ljava/lang/Long;", new ParseLong(0));
        this.translatorMap.put("java.lang.Long.valueOf(Ljava/lang/String;)Ljava/lang/Long;", new ParseLong(0));
        this.translatorMap.put("java.lang.Short.compareTo(Ljava/lang/Short;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Short.intValue()I", new NumToShort());
        this.translatorMap.put("java.lang.Short.parseShort(Ljava/lang/String;)S", new ParseShort(0));
        this.translatorMap.put("java.lang.Short.doubleValue()D", new NumToDouble());
        this.translatorMap.put("java.lang.Short.floatValue()F", new NumToFloat());
        this.translatorMap.put("java.lang.Short.longValue()J", new NumToLong());
        this.translatorMap.put("java.lang.Short.byteValue()B", new NumToByte());
        this.translatorMap.put("java.lang.Short.shortValue()S", new NumToShort());
        this.translatorMap.put("java.lang.Short.toString()Ljava/lang/String;", shortToString);
        this.translatorMap.put("java.lang.Short.toString(S)Ljava/lang/String;", shortToStringWithArg);
        this.translatorMap.put("java.lang.Short.valueOf(S)Ljava/lang/Short;", new ParseShort(0));
        this.translatorMap.put("java.lang.Short.valueOf(Ljava/lang/String;)Ljava/lang/Short;", new ParseShort(0));
        this.translatorMap.put("java.lang.Double.compare(DD)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Double.compareTo(Ljava/lang/Double;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Double.parseDouble(Ljava/lang/String;)D", new ParseDouble(0));
        this.translatorMap.put("java.lang.Double.intValue()I", new NumToInt());
        this.translatorMap.put("java.lang.Double.doubleValue()D", new NumToDouble());
        this.translatorMap.put("java.lang.Double.floatValue()F", new NumToFloat());
        this.translatorMap.put("java.lang.Double.longValue()J", new NumToLong());
        this.translatorMap.put("java.lang.Double.byteValue()B", new NumToByte());
        this.translatorMap.put("java.lang.Double.shortValue()S", new NumToShort());
        this.translatorMap.put("java.lang.Double.toString()Ljava/lang/String;", doubleToString);
        this.translatorMap.put("java.lang.Double.toString(D)Ljava/lang/String;", doubleToStringWithArg);
        this.translatorMap.put("java.lang.Double.valueOf(D)Ljava/lang/Double;", new ParseDouble(0));
        this.translatorMap.put("java.lang.Double.valueOf(Ljava/lang/String;)Ljava/lang/Double;", new ParseDouble(0));
        this.translatorMap.put("java.lang.Double.toHexString(D)Ljava/lang/String;", new ToCardinalNumberString(0, 2, JavaPrimitiveType.DOUBLE));
        this.translatorMap.put("java.lang.Float.compare(FF)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Float.compareTo(Ljava/lang/Float;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Float.intValue()I", new NumToInt());
        this.translatorMap.put("java.lang.Float.parseFloat(Ljava/lang/String;)F", new ParseFloat(0));
        this.translatorMap.put("java.lang.Float.doubleValue()D", new NumToDouble());
        this.translatorMap.put("java.lang.Float.floatValue()F", new NumToFloat());
        this.translatorMap.put("java.lang.Float.longValue()J", new NumToLong());
        this.translatorMap.put("java.lang.Float.byteValue()B", new NumToByte());
        this.translatorMap.put("java.lang.Float.shortValue()S", new NumToShort());
        this.translatorMap.put("java.lang.Float.toString()Ljava/lang/String;", floatToString);
        this.translatorMap.put("java.lang.Float.toString(F)Ljava/lang/String;", floatToStringWithArg);
        this.translatorMap.put("java.lang.Float.valueOf(F)Ljava/lang/Float;", new ParseFloat(0));
        this.translatorMap.put("java.lang.Float.valueOf(Ljava/lang/String;)Ljava/lang/Float;", new ParseFloat(0));
        this.translatorMap.put("java.lang.Float.toHexString(F)Ljava/lang/String;", new ToCardinalNumberString(0, 2, JavaPrimitiveType.FLOAT));
        this.translatorMap.put("java.lang.Byte.compareTo(Ljava/lang/Byte;)I", retIntWithNegVal);
        this.translatorMap.put("java.lang.Byte.parseByte(Ljava/lang/String;)B", new ParseByte(0));
        this.translatorMap.put("java.lang.Byte.intValue()I", new NumToInt());
        this.translatorMap.put("java.lang.Byte.doubleValue()D", new NumToDouble());
        this.translatorMap.put("java.lang.Byte.floatValue()F", new NumToFloat());
        this.translatorMap.put("java.lang.Byte.longValue()J", new NumToLong());
        this.translatorMap.put("java.lang.Byte.byteValue()B", new NumToByte());
        this.translatorMap.put("java.lang.Byte.shortValue()S", new NumToShort());
        this.translatorMap.put("java.lang.Byte.toString()Ljava/lang/String;", new ToString(JavaPrimitiveType.BYTE));
        this.translatorMap.put("java.lang.Byte.toString(B)Ljava/lang/String;", new ToString(0, JavaPrimitiveType.BYTE));
        this.translatorMap.put("java.lang.Byte.valueOf(B)Ljava/lang/Byte;", new ParseByte(0));
        this.translatorMap.put("java.lang.Byte.valueOf(Ljava/lang/String;)Ljava/lang/Byte;", new ParseByte(0));
        this.translatorMap.put("java.util.Properties.getProperty(Ljava/lang/String;)Ljava/lang/String;", new GetProperty(0));
        this.translatorMap.put("java.io.File.<init>(Ljava/lang/String;Ljava/lang/String;)V", new FileJoin(new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("java.io.File.<init>(Ljava/lang/String;Ljava/io/File;)V", new FileJoin(new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("java.io.File.<init>(Ljava/io/File;Ljava/lang/String;)V", new FileJoin(new IntRange[]{new IntRange(0, -1)}));
        this.translatorMap.put("java.io.File.<init>(Ljava/lang/String;)V", new Identity(0));
        this.translatorMap.put("java.io.File.<init>(Ljava/net/URI;)V", new Identity(0));
        this.translatorMap.put("java.io.File.getAbsolutePath()Ljava/lang/String;", new GetAbsoluteFile());
        this.translatorMap.put("java.io.File.getAbsoluteFile()Ljava/io/File;", new GetAbsoluteFile());
        this.translatorMap.put("java.io.File.getName()Ljava/lang/String;", new GetFileName());
        this.translatorMap.put("java.io.File.getPath()Ljava/lang/String;", new Identity(-1));
        this.translatorMap.put("java.io.File.toString()Ljava/lang/String;", new Identity(-1));
        this.translatorMap.put("java.io.BufferedReader.readLine()Ljava/lang/String;", new ReadLine());
        this.translatorMap.put("java.io.LineNumberReader.readLine()Ljava/lang/String;", new ReadLine());
        this.translatorMap.put("java.lang.System.getProperty(Ljava/lang/String;)Ljava/lang/String;", new GetProperty(0));
        this.translatorMap.put("junit.framework.TestCase.getName()Ljava/lang/String;", new ToString());
        this.translatorMap.put("java.lang.StringBuilder.toString()Ljava/lang/String;", new ToString());
        this.translatorMap.put("java.lang.StringBuilder.append(Ljava/lang/String;)Ljava/lang/StringBuilder;", concat);
        this.translatorMap.put("java.net.URLEncoder.encode(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", new NetUrlEncoder());
        this.translatorMap.put("java.net.URLDecoder.decode(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", new NetUrlDecoder());
        this.translatorMap.put("java.net.URI.<init>(Ljava/lang/String;)V", new Identity(0));
        this.translatorMap.put("java.net.URL.<init>(Ljava/lang/String;)V", new Identity(0));
        this.translatorMap.put("sun.misc.BASE64Encoder.encode([B)Ljava/lang/String;", new Base64Encode());
        this.translatorMap.put("sun.misc.BASE64Encoder.encode(Ljava/nio/ByteBuffer;)Ljava/lang/String;", new Base64Encode());
        this.translatorMap.put("java.util.regex.Pattern.compile(Ljava/lang/String;)Ljava/util/regex/Pattern;", new Identity(0));
        this.translatorMap.put("java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", new JavaPatternMatcher());
        this.translatorMap.put("java.util.regex.Matcher.group(I)Ljava/lang/String;", new JavaMatcherGroup("java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;"));
        this.translatorMap.put("java.util.regex.Matcher.replaceAll(Ljava/lang/String;)Ljava/lang/String;", new JavaMatcherReplaceAll("java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", 0));
        this.translatorMap.put("&java.lang.Character.isLetter(C)Z", new IsLetter());
        this.translatorMap.put("!java.lang.Character.isLetter(C)Z", new IsNotLetter());
        this.translatorMap.put("&java.lang.Character.isDigit(C)Z", new IsDigit());
        this.translatorMap.put("!java.lang.Character.isDigit(C)Z", new IsNotDigit());
        this.translatorMap.put("&java.lang.Character.isLetterOrDigit(C)Z", new IsLetterOrDigit());
        this.translatorMap.put("!java.lang.Character.isLetterOrDigit(C)Z", new IsNotLetterOrDigit());
        this.translatorMap.put("&java.lang.Character.isSpaceChar(C)Z", new IsSpaceChar());
        this.translatorMap.put("!java.lang.Character.isSpaceChar(C)Z", new IsNotSpaceChar());
        this.translatorMap.put("&java.lang.Character.isWhitespace(C)Z", new IsWhitespace());
        this.translatorMap.put("!java.lang.Character.isWhitespace(C)Z", new IsNotWhitespace());
        this.translatorMap.put("&java.lang.String.equals(Ljava/lang/Object;)Z", new StringEquals(0, 0));
        this.translatorMap.put("!java.lang.String.equals(Ljava/lang/Object;)Z", new NotStringEquals(0, 0));
        this.translatorMap.put("&java.lang.String.contains(Ljava/lang/CharSequence;)Z", new Contains(-1, 0));
        this.translatorMap.put("!java.lang.String.contains(Ljava/lang/CharSequence;)Z", new NotContains(-1, 0));
        this.translatorMap.put("&java.lang.String.matches(Ljava/lang/String;)Z", new RegexMatches(-1, 0));
        this.translatorMap.put("!java.lang.String.matches(Ljava/lang/String;)Z", new NotRegexMatches(-1, 0));
        this.translatorMap.put("&java.util.regex.Pattern.matches(Ljava/lang/String;Ljava/lang/CharSequence;)Z", new RegexMatches(0, 1));
        this.translatorMap.put("!java.util.regex.Pattern.matches(Ljava/lang/String;Ljava/lang/CharSequence;)Z", new NotRegexMatches(0, 1));
        this.translatorMap.put("&java.util.regex.Matcher.matches()Z", new JavaMatcherMatches("java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;"));
        this.translatorMap.put("!java.util.regex.Matcher.matches()Z", new JavaMatcherNotMatches("java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;"));
        this.translatorMap.put("&java.lang.String.length()I", new StringLengthCheck(-1));
        this.translatorMap.put("&java.lang.String.indexOf(Ljava/lang/String;)I", new StringIndexOf(-1, 0, TypeReference.JavaLangString));
        this.translatorMap.put("&java.lang.String.indexOf(I)I", new StringIndexOf(-1, 0, TypeReference.Int));
        this.translatorMap.put("&java.lang.String.indexOf(II)I", new StringIndexOf(-1, 0, TypeReference.Int));
        this.translatorMap.put("&java.lang.String.indexOf(Ljava/lang/String;I)I", new StringIndexOf(-1, 0, TypeReference.JavaLangString));
        this.translatorMap.put("!java.lang.String.indexOf(Ljava/lang/String;)I", new StringIndexOf(-1, 0, TypeReference.JavaLangString));
        this.translatorMap.put("!java.lang.String.indexOf(I)I", new StringIndexOf(-1, 0, TypeReference.Int));
        this.translatorMap.put("!java.lang.String.indexOf(II)I", new StringIndexOf(-1, 0, TypeReference.Int));
        this.translatorMap.put("!java.lang.String.indexOf(Ljava/lang/String;I)I", new StringIndexOf(-1, 0, TypeReference.JavaLangString));
        this.translatorMap.put("&#const.java.lang.String.indexOf(I)I", new StringConstIndexOf(-1, 1));
        this.translatorMap.put("!#const.java.lang.String.indexOf(I)I", new StringConstIndexOf(-1, 1));
        this.translatorMap.put("&#const.java.lang.String.indexOf(Ljava/lang/String;)I", new StringConstIndexOf(-1, 1));
        this.translatorMap.put("!#const.java.lang.String.indexOf(Ljava/lang/String;)I", new StringConstIndexOf(-1, 1));
        this.translatorMap.put("&#const.java.lang.String.equals(Ljava/lang/Object;)Z", new StringEquals(-1, 1));
        this.translatorMap.put("!#const.java.lang.String.equals(Ljava/lang/Object;)Z", new NotStringEquals(-1, 1));
        this.translatorMap.put("&java.util.Map.containsKey(Ljava/lang/Object;)Z", new StringMapContainsKey());
        this.translatorMap.put("&java.util.TreeMap.containsKey(Ljava/lang/Object;)Z", new StringMapContainsKey());
        this.translatorMap.put("&java.util.HashMap.containsKey(Ljava/lang/Object;)Z", new StringMapContainsKey());
    }

    protected void initMapTranslators() {
        this.translatorMap.put("java.util.Map.put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", new StringMapPut(0, 1));
        this.translatorMap.put("java.util.Map.get(Ljava/lang/Object;)Ljava/lang/Object;", new StringMapGet(0));
        this.translatorMap.put("java.util.HashMap.<init>()V", new StringMapInit());
        this.translatorMap.put("java.util.HashMap.put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", new StringMapPut(0, 1));
        this.translatorMap.put("java.util.HashMap.get(Ljava/lang/Object;)Ljava/lang/Object;", new StringMapGet(0));
        this.translatorMap.put("java.util.TreeMap.<init>()V", new StringMapInit());
        this.translatorMap.put("java.util.TreeMap.put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", new StringMapPut(0, 1));
        this.translatorMap.put("java.util.TreeMap.get(Ljava/lang/Object;)Ljava/lang/Object;", new StringMapGet(0));
    }

    protected void initStringClasses() {
        for (int i = 0; i < defaultStringClasses.length; ++i) {
            this.stringClasses.add(defaultStringClasses[i]);
        }
    }

    public boolean isStringClass(String classSignature) {
        return this.stringClasses.contains(classSignature);
    }

    public int[] getParams(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        int[] params;
        if (invoke.isStatic()) {
            params = new int[invoke.getNumberOfParameters()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i);
            }
        } else {
            params = new int[invoke.getNumberOfParameters() - 1];
            for (int i = 0; i < params.length; ++i) {
                params[i] = invoke.getUse(i + 1);
            }
        }
        return params;
    }

    public int getReceiver(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        if (invoke.isStatic()) {
            return -1;
        }
        return invoke.getReceiver();
    }

    public int[] getParams(IR ir) {
        int[] p = ir.getParameterValueNumbers();
        if (ir.getMethod().isStatic()) {
            return p;
        }
        int[] r = new int[p.length - 1];
        for (int i = 0; i < r.length; ++i) {
            r[i] = p[i + 1];
        }
        return r;
    }

    public int getReceiver(IR ir) {
        if (ir.getMethod().isStatic()) {
            return -1;
        }
        if (ir.getNumberOfParameters() > 0) {
            return ir.getParameter(0);
        }
        return -1;
    }

    public Set<String> getSignature(SSAAbstractInvokeInstruction invoke, TranslationContext ctx) {
        return RepositoryUtil.getSignature(invoke, ctx, this);
    }

    public void loadMethod(String signature, int target, ClassLoader loader, Object ... args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int idx = signature.lastIndexOf(".");
        String className = signature.substring(0, idx);
        String methodName = signature.substring(idx + 1);
        methodName = methodName.substring(0, methodName.indexOf("("));
        this._loadMethod(signature, target, loader, className, methodName, args);
    }

    public void _loadMethod(String signature, int target, ClassLoader loader, String className, String methodName, Object ... args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        JavaBridge bridge = new JavaBridge(target, loader, className, methodName, args);
        this.translatorMap.put(signature, bridge);
    }

    public boolean isBuiltin(String signature, SSAAbstractInvokeInstruction instruction, CallGraph cg) {
        Set nodes = cg.getNodes(instruction.getDeclaredTarget());
        if (nodes.isEmpty()) {
            return true;
        }
        if (this.hasSignature(signature)) {
            return true;
        }
        for (CGNode node : nodes) {
            if (this.isBuiltin(node, node.getMethod().getDeclaringClass().getClassLoader().getReference())) continue;
            return false;
        }
        return true;
    }

    public boolean isBuiltin(CGNode node, ClassLoaderReference loader) {
        return loader.equals((Object)ClassLoaderReference.Primordial);
    }

    public IRegexParser getRegexParser() {
        return RepositoryUtil.getRegexParser();
    }

    public String getClassInitSignature() {
        return "<clinit>";
    }

    public String getInitSignature() {
        return "<init>";
    }
}

