/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.gradle;

import com.hcl.appscan.discovery.gradle.Messages;
import com.hcl.appscan.internal.discovery.gradle.GradleRunner;
import com.ibm.appscan.cli.config.handlers.DiscoveryHandler;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.cli.config.ConfigurationReader;
import com.ibm.appscan.internal.discovery.StrategyFactoryRegistry;
import com.ibm.appscan.internal.discovery.dir.DirectoryStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;

public class GradleStrategy
extends Strategy {
    private static final String GRADLE_PLUGIN_INIT_SCRIPT = "appscan.gradle";
    private File m_projectDir;
    private StrategyFactoryRegistry m_registry;

    public GradleStrategy() {
    }

    public GradleStrategy(File directory, IStrategyFactoryRegistry registry) {
        if (directory.isFile()) {
            directory = directory.getParentFile();
        }
        this.init(directory, registry);
    }

    public String getName() {
        return this.m_projectDir.getName();
    }

    public String getType() {
        return "Gradle Project";
    }

    public String getPath() {
        return this.m_projectDir.getPath();
    }

    public void init(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        this.m_projectDir = fileOrDirectory;
        this.m_registry = (StrategyFactoryRegistry)registry;
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--init-script");
        args.add(new File(CommonCore.getDirectoryLocator().getConfig(), GRADLE_PLUGIN_INIT_SCRIPT).getAbsolutePath());
        args.add("generate-appscan-config");
        args.add("-DSAClientInstall=\"" + new File(CommonCore.getDirectoryLocator().getProductRoot()).getParent() + "\"");
        args.add("-DskipUpdate");
        args.add("-x test");
        args.add("-x javadoc");
        if (SystemUtil.isSourceCodeOnly()) {
            args.add("-DsourceCodeOnly=true");
        }
        if (SystemUtil.isOpenSourceOnly()) {
            args.add("-DopenSourceOnly=true");
        }
        if (SystemUtil.isStaticAnalysisOnly()) {
            args.add("-DstaticAnalysisOnly=true");
        }
        try {
            new GradleRunner(this.m_projectDir).run(args);
            File configFile = new File(this.m_projectDir, "build/appscan-config.xml");
            ConfigurationReader reader = new ConfigurationReader(configFile, null);
            reader.read();
            Map targetsToDiscover = reader.getScanTargetHandler().getScanTargets();
            new DiscoveryHandler().discover(targetsToDiscover);
        }
        catch (IOException | XMLStreamException e) {
            CommonCore.getLogManager().log(new Message(2, Messages.getMessage("gradle.plugin.error", e.getLocalizedMessage())));
            proxy.newScanTarget((ScanTargetStrategy)new DirectoryStrategy(this.m_projectDir, DiscoveryCore.getThirdPartyLibTarget(), this.m_registry));
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }
}

