/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.scm.git;

import com.hcl.appscan.common.scm.IScmProvider;
import com.hcl.appscan.common.scm.IScmProviderFactory;
import com.hcl.appscan.discovery.scm.git.GitProvider;
import com.hcl.appscan.discovery.scm.git.Messages;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;

public class GitProviderFactory
implements IScmProviderFactory {
    public String getName() {
        return "git";
    }

    public IScmProvider createProvider(Properties properties) {
        return new GitProvider(properties);
    }

    public IScmProvider initializeFromDirectory(File directory, IProgress progress) {
        GitProvider provider = null;
        if (directory.exists()) {
            try {
                if (directory.isFile()) {
                    directory = directory.getParentFile();
                }
                while (directory != null) {
                    if (GitProviderFactory.containsGitFolder(directory)) {
                        File dotGit = new File(directory, ".git");
                        String branchName = GitProviderFactory.getBranchName(dotGit);
                        String baseUrl = GitProviderFactory.getBaseUrl(dotGit, branchName);
                        String commitId = GitProviderFactory.getCommitForBranch(dotGit, branchName);
                        provider = new GitProvider(directory, baseUrl, commitId, branchName);
                        break;
                    }
                    directory = directory.getParentFile();
                }
            }
            catch (IOException e) {
                progress.setStatus(new Message(2, Messages.getMessage("git.discovery.error", e.getMessage())));
            }
        }
        return provider;
    }

    private static boolean containsGitFolder(File directory) {
        String[] files = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.getName().equalsIgnoreCase(".git") || name.equalsIgnoreCase(".git");
            }
        });
        return files != null && files.length > 0;
    }

    private static String getBranchName(File gitDirectory) throws IOException {
        String branch = GitProviderFactory.readFirstLineOfFile(new File(gitDirectory, "HEAD"));
        return branch.contains("refs/heads/") ? branch.substring(branch.lastIndexOf("refs/heads/") + 11) : branch;
    }

    private static String getCommitForBranch(File gitDirectory, String branchName) throws IOException {
        File refsFile = new File(gitDirectory, "/refs/heads/" + branchName);
        return refsFile.isFile() ? GitProviderFactory.readFirstLineOfFile(refsFile) : branchName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBaseUrl(File gitDirectory, String branchName) throws IOException {
        String string;
        File config = new File(gitDirectory, "config");
        BufferedReader br = null;
        String url = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(config));
            while ((line = br.readLine()) != null) {
                if (!line.trim().startsWith("url =")) continue;
                url = GitProviderFactory.getHttpsUrl(line.split("=")[1].trim());
                break;
            }
            if (url == null) {
                throw new IOException(Messages.getMessage("remote.not.found", new Object[0]));
            }
            string = url;
        }
        catch (Throwable throwable) {
            IOUtil.close(br);
            throw throwable;
        }
        IOUtil.close((Closeable)br);
        return string;
    }

    private static String readFirstLineOfFile(File file) throws IOException {
        String string;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            string = br.readLine();
        }
        catch (Throwable throwable) {
            IOUtil.close(br);
            throw throwable;
        }
        IOUtil.close((Closeable)br);
        return string;
    }

    private static String getHttpsUrl(String url) {
        if (url.endsWith(".git")) {
            url = url.substring(0, url.length() - 4);
        }
        if (url.startsWith("git@")) {
            url = url.replaceFirst(":", "/");
            url = url.replaceFirst("git@", "https://");
        }
        return url;
    }
}

