/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader;

import com.ibm.wala.classLoader.FileModule;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.dotnet.loader.LowLevelInterface;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public class AssemblyModule<C, F, M, A, T>
extends FileModule {
    private final A imageHandle;
    protected final LowLevelInterface<C, F, M, A, T> reader;
    private final SetOfClasses exclusions;

    protected AssemblyModule(File f, LowLevelInterface<C, F, M, A, T> reader, SetOfClasses exclusions, boolean isSystemImage, Module container) throws IllegalArgumentException {
        super(f, container);
        this.reader = reader;
        this.imageHandle = reader.findImage(this.getAbsolutePath(), isSystemImage);
        this.exclusions = exclusions;
    }

    public LowLevelInterface<C, F, M, A, T> getReader() {
        return this.reader;
    }

    public boolean isClassFile() {
        return true;
    }

    public boolean isExcluded(C c) {
        String clsName = this.reader.classGetName(c);
        return this.exclusions.contains(clsName);
    }

    public boolean isSourceFile() {
        return false;
    }

    public A getHandle() {
        return this.imageHandle;
    }

    public String getClassName() {
        return this.reader.imageGetAssemblyName(this.imageHandle);
    }

    protected int numberOfClasses() {
        return this.reader.numberOfClasses(this.imageHandle);
    }

    protected int numberOfMethods() {
        return this.reader.numberOfMethods(this.imageHandle);
    }

    protected Collection<String> classSourceFiles(C classHandle) {
        String[] sourceFiles = this.reader.classGetSourceFiles(classHandle);
        if (sourceFiles == null) {
            return null;
        }
        HashSet result = HashSetFactory.make((int)sourceFiles.length);
        for (String s : sourceFiles) {
            result.add(s);
        }
        return result;
    }

    protected C[] getAllClasses() {
        return this.reader.imageAllClasses(this.imageHandle);
    }

    protected C getClass(String name, String pkg) {
        return this.reader.findClass(this.imageHandle, name, pkg);
    }

    protected Collection<String> getClassSourceFiles(String className, String pkg) {
        return this.classSourceFiles(this.reader.findClass(this.imageHandle, className, pkg));
    }
}

