/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.dotnet.loader;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.config.SetOfClasses;
import com.ibm.wala.util.debug.Assertions;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class DotNetSetOfClasses
extends SetOfClasses {
    private final String exclusionFile;
    private final Collection<String> exclusionsList;
    private static final long serialVersionUID = 1L;

    public DotNetSetOfClasses(String exclusionFile) {
        this.exclusionFile = exclusionFile;
        this.exclusionsList = this.parseExclusionsFile(exclusionFile);
    }

    private Collection<String> parseExclusionsFile(String exclusionsFile) {
        HashSet result = HashSetFactory.make();
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.exclusionFile));
            String line = "";
            if (!in.ready()) {
                in.close();
                throw new IOException();
            }
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                result.add(line);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean contains(String klassName) {
        for (String exclusion : this.exclusionsList) {
            if (!klassName.startsWith(exclusion)) continue;
            return true;
        }
        return false;
    }

    public void add(String klass) {
        Assertions.UNREACHABLE();
    }
}

