/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util;

import com.ibm.wala.util.collections.HashSetFactory;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Set;

public class Output {
    private final Set<PrintStream> outs;
    private final boolean _doPrint;

    public static Output makeFileAndStdOutOutput(boolean doPrint, String filename) {
        Output o = new Output(doPrint, filename);
        o.addOutput(System.out);
        return o;
    }

    public static Output makeFileAndStdErrOutput(boolean doPrint, String filename) {
        Output o = new Output(doPrint, filename);
        o.addOutput(System.err);
        return o;
    }

    public static Output makeStdOutOutput(boolean doPrint) {
        return new Output(doPrint, System.out);
    }

    public Output(boolean doPrint) {
        this.outs = HashSetFactory.make();
        this._doPrint = doPrint;
    }

    public Output(boolean doPrint, String filename) {
        this.outs = HashSetFactory.make();
        this._doPrint = doPrint;
        if (this._doPrint) {
            try {
                this.outs.add(new PrintStream(filename));
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("Could not find file: " + filename);
                fnfe.printStackTrace(System.err);
            }
        }
    }

    public Output(boolean doPrint, PrintStream ps) {
        this.outs = HashSetFactory.make();
        this.outs.add(ps);
        this._doPrint = doPrint;
    }

    public Output(boolean doPrint, Set<PrintStream> outputs) {
        this.outs = outputs;
        this._doPrint = doPrint;
    }

    public void addOutput(PrintStream o) {
        this.outs.add(o);
    }

    public void writeln(String s) {
        if (this._doPrint) {
            for (PrintStream ps : this.outs) {
                ps.println(s);
            }
        }
    }

    public void writeln(Exception e) {
        if (this._doPrint) {
            for (PrintStream ps : this.outs) {
                e.printStackTrace(ps);
            }
        }
    }

    public void writeln(Error e) {
        if (this._doPrint) {
            for (PrintStream ps : this.outs) {
                e.printStackTrace(ps);
            }
        }
    }

    public void writeln() {
        if (this._doPrint) {
            for (PrintStream ps : this.outs) {
                ps.println();
            }
        }
    }
}

