/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util.frameworks;

import com.ibm.wala.jstaint.util.frameworks.FrameworkSignatureUtil;
import com.ibm.wala.jstaint.util.frameworks.MethodArgument;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import java.util.List;
import java.util.Map;

public class MethodSignature {
    private final String returnType;
    private final String packageName;
    private final String className;
    private final String methodName;
    private final List<MethodArgument> args;
    private static int nullVarCount = 0;

    public MethodSignature(String returnType, String packageName, String className, String methodName, List<MethodArgument> args) {
        this.returnType = returnType;
        this.packageName = packageName;
        this.className = className;
        this.methodName = methodName;
        this.args = args;
    }

    public String getDeclString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.returnType);
        sb.append(" ");
        sb.append(this.methodName);
        sb.append("(");
        for (int i = 0; i < this.args.size(); ++i) {
            MethodArgument a = this.args.get(i);
            sb.append(a.type);
            sb.append(" ");
            sb.append(a.varName);
            if (i + 1 >= this.args.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getFullyQualifiedClass() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.packageName);
        sb.append('.');
        sb.append(this.className);
        return sb.toString();
    }

    public String getFullyQualifiedClassJVM() {
        StringBuilder sb = new StringBuilder();
        sb.append(FrameworkSignatureUtil.dotsToSlashes(this.packageName));
        sb.append("/");
        sb.append(this.className);
        return sb.toString();
    }

    public String getDescriptorJVM() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < this.args.size(); ++i) {
            MethodArgument a = this.args.get(i);
            sb.append(FrameworkSignatureUtil.dotsToSlashesWithoutLeadingL(FrameworkSignatureUtil.javaTypeToJVMType(a.type)));
        }
        sb.append(')');
        sb.append(FrameworkSignatureUtil.dotsToSlashesWithoutLeadingL(FrameworkSignatureUtil.javaTypeToJVMType(this.returnType)));
        return sb.toString();
    }

    public String getJVMSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.packageName);
        sb.append('.');
        sb.append(this.className);
        sb.append('.');
        sb.append(this.methodName);
        sb.append(this.getDescriptorJVM());
        return sb.toString();
    }

    public String getCallString(Map<Integer, String> actuals, boolean isStatic, boolean isClassAbstract) {
        int actualsOffset;
        StringBuilder sb = new StringBuilder();
        String fullyQualifiedClass = this.getFullyQualifiedClass();
        if (isStatic) {
            sb.append(fullyQualifiedClass);
            sb.append('.');
            actualsOffset = 0;
        } else if (isClassAbstract) {
            if (actuals.containsKey(0)) {
                sb.append(actuals.get(0));
            } else {
                String nullVar = "null_" + nullVarCount++;
                sb.append(fullyQualifiedClass);
                sb.append(" ");
                sb.append(nullVar);
                sb.append(" = (");
                sb.append(fullyQualifiedClass);
                sb.append(") makeNull(); ");
                sb.append(nullVar);
            }
            sb.append('.');
            actualsOffset = 1;
        } else {
            if (actuals.containsKey(0)) {
                sb.append(actuals.get(0));
            } else {
                sb.append("(new ");
                sb.append(fullyQualifiedClass);
                sb.append("())");
            }
            sb.append('.');
            actualsOffset = 1;
        }
        sb.append(this.methodName);
        sb.append('(');
        for (int i = 0; i < this.args.size(); ++i) {
            MethodArgument a = this.args.get(i);
            int actualsIndex = i + actualsOffset;
            if (actuals.containsKey(actualsIndex)) {
                sb.append(actuals.get(actualsIndex));
            } else {
                String type = a.type;
                if (type.equals("int")) {
                    sb.append("0");
                } else if (type.equals("char")) {
                    sb.append("'0'");
                } else if (type.equals("long")) {
                    sb.append("0L");
                } else if (type.equals("boolean")) {
                    sb.append("false");
                } else if (type.equals("double")) {
                    sb.append("0.0d");
                } else if (type.equals("float")) {
                    sb.append("0.0f");
                } else if (type.equals("short")) {
                    sb.append("0");
                } else if (type.equals("byte")) {
                    sb.append("0");
                } else {
                    sb.append("(" + type + ") null");
                }
            }
            if (i + 1 >= this.args.size()) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public String getServletRequestParamName() {
        for (MethodArgument arg : this.args) {
            if (!arg.type.contains("ServletRequest")) continue;
            return arg.varName;
        }
        return null;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<MethodArgument> getArgs() {
        return this.args;
    }

    public int getNumArgs() {
        return this.args.size();
    }

    public String serializeToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.returnType);
        sb.append(" ");
        sb.append(this.packageName);
        sb.append(" ");
        sb.append(this.className);
        sb.append(" ");
        sb.append(this.methodName);
        sb.append(" ");
        for (MethodArgument a : this.args) {
            sb.append(a.serializeToString());
            sb.append(" ");
        }
        return sb.toString();
    }

    public MethodReference getMethodReference(ClassLoaderReference loader) {
        String jvmSig = this.getJVMSignature();
        String selector = jvmSig.substring(jvmSig.indexOf(40));
        return MethodReference.findOrCreate((ClassLoaderReference)loader, (String)this.getFullyQualifiedClassJVM(), (String)this.methodName, (String)selector);
    }

    public static MethodSignature deserializeFromString(String s) {
        String[] parts = s.split(" ", 5);
        List<MethodArgument> arguments = MethodArgument.deserializeFromString(parts[parts.length - 1]);
        return new MethodSignature(parts[0], parts[1], parts[2], parts[3], arguments);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.args == null ? 0 : this.args.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.returnType == null ? 0 : this.returnType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        if (this.args == null ? other.args != null : !this.args.equals(other.args)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        return !(this.returnType == null ? other.returnType != null : !this.returnType.equals(other.returnType));
    }

    public String toString() {
        return "MethodSignature [returnType=" + this.returnType + ", packageName=" + this.packageName + ", className=" + this.className + ", methodName=" + this.methodName + ", args=" + this.args + "]";
    }
}

