/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IStringAnalysisStatistics;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ApplicationResult;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SanitizerKind;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.StringAnalysisResult;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;

public class StringAnalysisStatus
implements IStringAnalysisStatistics {
    private final ApplicationResult result;
    private final Collection<SASpec> illegalPatterns;

    public StringAnalysisStatus(String application, Collection<SASpec> illegalPatterns) {
        this.result = new ApplicationResult(application, illegalPatterns);
        this.illegalPatterns = illegalPatterns;
    }

    public Collection<SASpec> getIllegalPatterns() {
        return this.illegalPatterns;
    }

    @Override
    public void reportSanitizer(IMethod method, Collection<SASpec> patterns, SanitizerKind kind) {
        String signature = method.getSignature();
        HashMap info = this.result.getMethodInfo(signature);
        if (info == null) {
            info = HashMapFactory.make();
            this.result.add(signature, info, "", "");
        }
        for (SASpec p : patterns) {
            info.put(p, kind);
        }
    }

    public void printReport(PrintWriter pw) {
        pw.println(StringAnalysisResult.getTitle1());
        pw.println(StringAnalysisResult.getTitle2(this.illegalPatterns));
        pw.write(this.result.toString());
    }

    public ApplicationResult getResult() {
        return this.result;
    }

    public static String appNameToFileName(String appName) {
        return (appName + ".saResults").replace('/', '#');
    }

    public static String fileNameToAppName(String fileName) {
        return fileName.substring(0, fileName.length() - ".saResults".length()).replace('#', '/');
    }

    public static boolean isSaResultFile(String fileName) {
        return fileName.endsWith(".saResults");
    }
}

