/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.ifa.tfidf;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.ifa.tfidf.TfidfException;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TrainingAndTestSetWriter {
    private static String m_testSetsPath = CommonCore.getDirectoryLocator().getMl() + "/tfidf/testsets/";

    private static File getTrainingSetPath(File originalVdbFile) throws IOException {
        String intermediatePath = originalVdbFile.getParentFile().getAbsolutePath().substring(CommonCore.getDirectoryLocator().getVdb().length() - 1) + File.separator;
        String trainingSetFileName = originalVdbFile.getName().substring(0, originalVdbFile.getName().lastIndexOf(46)) + "90.vdb";
        return PathUtil.getSanitizedFile((String)(m_testSetsPath + intermediatePath), (String)trainingSetFileName);
    }

    private static File getTestSetPath(File originalVdbFile) throws IOException {
        String intermediatePath = originalVdbFile.getParentFile().getAbsolutePath().substring(CommonCore.getDirectoryLocator().getVdb().length() - 1) + File.separator;
        String testSetFileName = originalVdbFile.getName().substring(0, originalVdbFile.getName().lastIndexOf(46)) + "10.vdb";
        return PathUtil.getSanitizedFile((String)(m_testSetsPath + intermediatePath), (String)testSetFileName);
    }

    public static void writeTrainingAndTestSet(File vdbFile) throws BadMarkupException, VDBGeneralException, TfidfException {
        File testDir;
        File trainingDir;
        try {
            trainingDir = TrainingAndTestSetWriter.getTrainingSetPath(vdbFile);
            testDir = TrainingAndTestSetWriter.getTestSetPath(vdbFile);
        }
        catch (IOException e) {
            throw new BadMarkupException((Exception)e);
        }
        if (trainingDir.exists() && testDir.exists()) {
            return;
        }
        if (!trainingDir.exists()) {
            trainingDir.mkdirs();
        }
        if (!testDir.exists()) {
            testDir.mkdirs();
        }
        Vdb v = VdbProvider.getVdb((File)vdbFile);
        List<Vdb> sets = TrainingAndTestSetWriter.splitVdb9010(v);
        VdbProvider.saveVdb((Vdb)sets.get(0), (File)trainingDir);
        VdbProvider.saveVdb((Vdb)sets.get(1), (File)testDir);
    }

    public static List<Vdb> splitVdb9010(Vdb vdb) throws BadMarkupException, TfidfException {
        return TrainingAndTestSetWriter.splitVdb(vdb, 0.9);
    }

    public static List<Vdb> splitVdb8020(Vdb vdb) throws BadMarkupException, TfidfException {
        return TrainingAndTestSetWriter.splitVdb(vdb, 0.8);
    }

    public static List<Vdb> splitVdb7030(Vdb vdb) throws BadMarkupException, TfidfException {
        return TrainingAndTestSetWriter.splitVdb(vdb, 0.7);
    }

    private static List<Vdb> splitVdb(Vdb vdb, double trainingSetDec) throws BadMarkupException, TfidfException {
        int i;
        if (trainingSetDec > 1.0) {
            throw new TfidfException("Training set to Test set ratio needs to be less than 1");
        }
        Vdb trainingSet = new Vdb(vdb.getLang());
        Vdb testSet = new Vdb(vdb.getLang());
        int split = (int)((double)vdb.getMethods().size() * trainingSetDec);
        for (i = 0; i < split; ++i) {
            trainingSet.addMethod((Method)vdb.getMethods().get(i));
        }
        for (i = split; i < vdb.getMethods().size(); ++i) {
            testSet.addMethod((Method)vdb.getMethods().get(i));
        }
        ArrayList<Vdb> splitVdbs = new ArrayList<Vdb>();
        splitVdbs.add(trainingSet);
        splitVdbs.add(testSet);
        return splitVdbs;
    }
}

