/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.cache;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.cache.AuditCache;
import com.ibm.appscan.vdb.cache.BaseVdbCache;
import com.ibm.appscan.vdb.cache.VdbFactoryCache;
import com.ibm.appscan.vdb.cache.VdbIgnoreCache;
import com.ibm.appscan.vdb.cache.VdbMissingCache;
import com.ibm.appscan.vdb.cache.VdbNewCache;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.util.HashMap;

public class CacheProvider {
    private static CacheProvider s_cache_provider = new CacheProvider();
    private HashMap<Language.LANGUAGE, HashMap<VDBEnums.BUCKET, BaseVdbCache>> m_cache = new HashMap();
    private HashMap<Language.LANGUAGE, AuditCache> m_audit_cache = new HashMap();

    private CacheProvider() {
    }

    private static CacheProvider getInstance() {
        VdbProvider.setRestMode(false);
        return s_cache_provider;
    }

    @SuppressSecurityTrace
    public static synchronized BaseVdbCache getCache(Language.LANGUAGE l, VDBEnums.BUCKET b) {
        if (!CacheProvider.getInstance().m_cache.containsKey(l)) {
            CacheProvider.getInstance().m_cache.put(l, new HashMap());
        }
        if (!CacheProvider.getInstance().m_cache.get(l).containsKey((Object)b)) {
            if (b == VDBEnums.BUCKET.FACTORY) {
                CacheProvider.getInstance().m_cache.get(l).put(b, new VdbFactoryCache(l));
            } else if (b == VDBEnums.BUCKET.IGNORE) {
                CacheProvider.getInstance().m_cache.get(l).put(b, new VdbIgnoreCache(l, VDBEnums.BUCKET.IGNORE));
            } else if (b == VDBEnums.BUCKET.MISSING) {
                CacheProvider.getInstance().m_cache.get(l).put(b, new VdbMissingCache(l, VDBEnums.BUCKET.MISSING));
            } else if (b == VDBEnums.BUCKET.NEW) {
                CacheProvider.getInstance().m_cache.get(l).put(b, new VdbNewCache(l, VDBEnums.BUCKET.NEW));
            } else {
                CacheProvider.getInstance().m_cache.get(l).put(b, new BaseVdbCache(l, b));
            }
        }
        return CacheProvider.getInstance().m_cache.get(l).get((Object)b);
    }

    public static void clearCache() {
        CacheProvider.getInstance().m_cache.clear();
    }

    public static AuditCache getAuditCache(String lang) {
        return CacheProvider.getAuditCache(Language.getLanguage((String)lang));
    }

    public static synchronized AuditCache getAuditCache(Language.LANGUAGE l) {
        if (!CacheProvider.getInstance().m_audit_cache.containsKey(l)) {
            CacheProvider.getInstance().m_audit_cache.put(l, new AuditCache(l));
        }
        return CacheProvider.getInstance().m_audit_cache.get(l);
    }
}

