/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.data;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.data.VdbClass;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.method.MethodProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class VdbPackage
extends VdbArtifact
implements Comparable<VdbPackage> {
    private TreeMap<String, VdbClass> m_classes;

    public VdbPackage(String name, Language.LANGUAGE lang) {
        super(lang);
        this.setPackageName(name);
    }

    public VdbPackage(VdbPackage p) throws BadMarkupException {
        this.setLang(p.getLang());
        this.setPackageName(p.getPackageName());
        this.setFramework(p.getFramework());
        this.merge(p);
    }

    public Collection<VdbClass> getClassesVdb() {
        return this.getClassMap().values();
    }

    public TreeMap<String, VdbClass> getClassMap() {
        if (this.m_classes == null) {
            this.m_classes = new TreeMap();
        }
        return this.m_classes;
    }

    public VdbClass getClassVdb(String name) {
        return this.getClassMap().get(name);
    }

    public boolean addClass(VdbClass c) throws BadMarkupException {
        if (this.getLang() == null) {
            throw new BadMarkupException("Package language is null", new Object[0]);
        }
        if (c.getLang() == null) {
            c.setLang(this.getLang());
        }
        if (!c.getLang().equals((Object)this.getLang())) {
            throw new BadMarkupException("Class language {1} and package language {1} need to be the same", this.getLang(), this.getLang());
        }
        if (c.getPackageName() == null) {
            c.setPackageName(this.getPackageName());
        }
        if (this.getClassMap().containsKey(c.getClassName())) {
            if (this.getClassVdb(c.getClassName()).equals(c)) {
                return false;
            }
            return this.getClassMap().get(c.getClassName()).merge(c);
        }
        c.setFramework(this.getFramework());
        c.setPackageName(this.getPackageName());
        c.setLang(this.getLang());
        this.getClassMap().put(c.getClassName(), c);
        return true;
    }

    public ArrayList<Method> getMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (VdbClass c : this.getClassesVdb()) {
            methods.addAll(c.getMethods());
        }
        return methods;
    }

    public Method getMethod(String signature) {
        for (VdbClass c : this.getClassesVdb()) {
            if (c.getMethod(signature) == null) continue;
            return c.getMethod(signature);
        }
        return null;
    }

    public boolean addMethod(Method m) throws BadMarkupException {
        if (this.getLang() == null) {
            throw new BadMarkupException("Package language is null", new Object[0]);
        }
        if (m.getLang() == null) {
            m.setLang(this.getLang());
        }
        if (!m.getLang().equals((Object)this.getLang())) {
            throw new BadMarkupException("Method language {0} and package language {1} need to be the same.", m.getLang(), this.getLang());
        }
        if (m.getClassName() == null) {
            throw new BadMarkupException("Method {0} classname is null. A method being added to a package needs to specify a class name", m.getSignature());
        }
        if (this.getClassMap().get(m.getClassName()) != null) {
            return this.getClassMap().get(m.getClassName()).addMethod(m);
        }
        VdbClass c = new VdbClass(m.getClassName(), this.getLang());
        this.addClass(c);
        c.addMethod(m);
        return true;
    }

    public boolean deleteMethod(Method m) {
        return this.deleteMethod(m.getSignature());
    }

    public boolean deleteMethod(String signature) {
        Iterator<VdbClass> c_it = this.getClassesVdb().iterator();
        while (c_it.hasNext()) {
            VdbClass c = c_it.next();
            if (c.getMethod(signature) == null) continue;
            c.deleteMethod(c.getMethod(signature));
            if (c.getMethods().size() == 0) {
                c_it.remove();
            }
            return true;
        }
        return false;
    }

    public boolean deleteVdbClass(String name) {
        return this.getClassMap().remove(name) != null;
    }

    @Override
    public void replace(VdbArtifact e) throws BadMarkupException {
        if (e instanceof VdbPackage) {
            VdbPackage p = (VdbPackage)e;
            this.reset();
            this.setPackageName(p.getPackageName());
            this.setLang(p.getLang());
            this.setFramework(p.getFramework());
            this.merge(p);
        }
    }

    @Override
    public boolean merge(VdbArtifact e) throws BadMarkupException {
        boolean _ret = false;
        if (e instanceof VdbPackage) {
            VdbPackage p = (VdbPackage)e;
            for (Method m : p.getMethods()) {
                try {
                    this.addMethod(MethodProvider.getMethod(m));
                }
                catch (VDBException e1) {
                    throw new BadMarkupException(e1.getLocalizedMessage(), new Object[0]);
                }
            }
        }
        return _ret;
    }

    @Override
    public void reset() {
        this.m_classes = null;
    }

    @Override
    public int compareTo(VdbPackage p) {
        if (this.getLang() != null) {
            if (p.getLang() == null) {
                return 1;
            }
            if (this.getLang().compareTo((Enum)p.getLang()) != 0) {
                return this.getLang().compareTo((Enum)p.getLang());
            }
        }
        if (this.getPackageName() != null) {
            if (p.getPackageName() == null) {
                return 1;
            }
            if (this.getPackageName().compareTo(p.getPackageName()) != 0) {
                return this.getPackageName().compareTo(p.getPackageName());
            }
        }
        if (this.getClassesVdb().size() > p.getClassesVdb().size()) {
            return 1;
        }
        if (this.getClassesVdb().size() < p.getClassesVdb().size()) {
            return -1;
        }
        for (VdbClass c : this.getClassesVdb()) {
            if (p.getClassVdb(c.getClassName()) == null) {
                return 1;
            }
            if (c.compareTo(p.getClassVdb(c.getClassName())) == 0) continue;
            return c.compareTo(p.getClassVdb(c.getClassName()));
        }
        for (VdbClass c : p.getClassesVdb()) {
            if (this.getClassVdb(c.getClassName()) == null) {
                return -1;
            }
            if (c.compareTo(this.getClassVdb(c.getClassName())) == 0) continue;
            return c.compareTo(this.getClassVdb(c.getClassName()));
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o instanceof VdbPackage) {
            VdbPackage p = (VdbPackage)o;
            return this.compareTo(p) == 0;
        }
        return false;
    }

    public boolean isFullyMarkedUp() {
        if (this.getMethods().size() == 0) {
            return false;
        }
        for (Method m : this.getMethods()) {
            if (m.isMarkedUp()) continue;
            return false;
        }
        return true;
    }

    public Collection<VdbClass> getClasses() {
        return this.getClassMap().values();
    }
}

