/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.file.save.RuleStreamWriter;
import com.ibm.appscan.vdb.rule.DeleteRule;
import com.ibm.appscan.vdb.rule.Rule;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class RuleProvider {
    private Language.LANGUAGE m_lang = Language.LANGUAGE.JAVA;
    private HashMap<String, Rule> m_rules;

    public RuleProvider(Language.LANGUAGE lang) {
        this.m_lang = lang;
    }

    public String getType() {
        return "markup";
    }

    public boolean runRules(ArrayList<Method> methods) throws BadRuleException {
        boolean _ret = false;
        for (Rule r : this.getRules().values()) {
            for (Method m : methods) {
                if (!this.runRule(r, m)) continue;
                _ret = true;
            }
        }
        return _ret;
    }

    public boolean runRules(Method m) throws BadRuleException {
        boolean _ret = false;
        for (Rule r : this.getRules().values()) {
            if (!this.runRule(r, m)) continue;
            _ret = true;
        }
        return _ret;
    }

    public boolean runRule(Rule r, Method m) throws BadRuleException {
        if (r.isMatch(m)) {
            return r.applyRule(m);
        }
        return false;
    }

    public Rule createRule() {
        return this.createRule_(null, new Rule());
    }

    public boolean searchRules(Method m) throws BadRuleException {
        boolean _ret = false;
        for (Rule r : this.getRules().values()) {
            if (!this.searchRule(r, m)) continue;
            _ret = true;
        }
        return _ret;
    }

    public boolean searchRule(Rule r, Method m) throws BadRuleException {
        return r.isMatch(m);
    }

    public Rule createRule(String name) {
        return this.createRule_(name, new Rule());
    }

    public Rule createDeleteRule(String name) {
        return this.createRule_(name, new DeleteRule());
    }

    private Rule createRule_(String name, Rule rule) {
        if (name == null || name.length() == 0) {
            name = "Rule_" + this.getUniqueId();
        }
        if (this.getRules().containsKey(name)) {
            name = name + "_" + this.getUniqueId();
        }
        rule.setRuleName(name);
        this.addRule(rule);
        return this.getRules().get(name);
    }

    public void addRule(Rule r) {
        if (!this.getRules().containsKey(r.getRuleName())) {
            this.getRules().put(r.getRuleName(), r);
        }
    }

    public void deleteRule(Rule r) {
        this.deleteRule(r.getRuleName());
    }

    public void deleteRule(String name) {
        this.getRules().remove(name);
    }

    public Language.LANGUAGE getLanguage() {
        return this.m_lang;
    }

    public HashMap<String, Rule> getRules() {
        if (this.m_rules == null) {
            this.m_rules = new HashMap();
            try {
                for (Rule r : VdbProvider.getDataProvider(this.getLanguage()).getRules()) {
                    this.m_rules.put(r.getRuleName(), r);
                }
            }
            catch (VDBGeneralException e) {
                this.m_rules = new HashMap();
            }
        }
        return this.m_rules;
    }

    public Rule getRule(String name) {
        return this.getRules().get(name);
    }

    public void saveRules() throws VDBGeneralException {
        VdbProvider.getDataProvider(this.getLanguage()).saveRules(this.getRules().values());
    }

    private String getUniqueId() {
        return UUID.randomUUID().toString();
    }

    public String getRuleXml(Rule r) throws VDBGeneralException, BadRuleException {
        BufferedReader reader = null;
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            RuleStreamWriter writer = new RuleStreamWriter(stream);
            writer.writeRules(r);
            String string = stream.toString("UTF-8");
            return string;
        }
        catch (IOException e1) {
            throw new VDBGeneralException(e1);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new VDBGeneralException(e);
            }
        }
    }

    public String getRulesXml() throws VDBGeneralException, BadRuleException {
        BufferedReader reader = null;
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            RuleStreamWriter writer = new RuleStreamWriter(stream);
            writer.writeRules(this.getRules().values());
            String string = stream.toString("UTF-8");
            return string;
        }
        catch (IOException e1) {
            throw new VDBGeneralException(e1);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new VDBGeneralException(e);
            }
        }
    }
}

