/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.load;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.ValidationRoutine;
import com.ibm.appscan.vdb.method.markup.valid.Descriptor;
import com.ibm.appscan.vdb.provider.data.file.load.BaseXmlStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class ValidationRoutineHandler
extends BaseXmlStreamReader {
    private XMLEventReader m_xmlReader;
    private HashMap<String, Descriptor> m_descriptors = new HashMap();
    private HashMap<String, ValidationRoutine> m_routines = new HashMap();
    private Language.LANGUAGE m_lang = Language.LANGUAGE.JAVA;
    private Descriptor m_current_descriptor;

    public ValidationRoutineHandler(File validation_xml, Language.LANGUAGE lang) throws VDBGeneralException, FileNotFoundException {
        this(new FileInputStream(validation_xml), lang);
    }

    public ValidationRoutineHandler(InputStream validation_in, Language.LANGUAGE lang) throws VDBGeneralException {
        this.m_lang = lang;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            this.m_xmlReader = factory.createFilteredReader(factory.createXMLEventReader(validation_in), this);
        }
        catch (XMLStreamException e) {
            throw new VDBGeneralException(e);
        }
    }

    public boolean parse() throws VDBGeneralException {
        try {
            this.read(this.m_xmlReader);
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            if (e.getLocalizedMessage().contains("START_ELEMENT")) {
                boolean bl = true;
                return bl;
            }
            throw new VDBGeneralException(e);
        }
        finally {
            if (this.m_xmlReader != null) {
                try {
                    this.m_xmlReader.close();
                }
                catch (XMLStreamException e) {
                    throw new VDBGeneralException(e);
                }
            }
        }
    }

    @Override
    protected boolean process(StartElement element) {
        try {
            if (element.getName().getLocalPart().equals("Descriptor")) {
                this.m_current_descriptor = new Descriptor(this.getAttribute(element, "type"));
            }
            if (element.getName().getLocalPart().equals("SourceProperty")) {
                this.m_current_descriptor.addSourceProperty(this.getAttribute(element, "property"));
            }
            if (element.getName().getLocalPart().equals("SinkProperty")) {
                this.m_current_descriptor.addSinkProperty(this.getAttribute(element, "property"));
            }
            if (element.getName().getLocalPart().equals("Source")) {
                this.m_current_descriptor.addSource(this.getAttribute(element, "sig"));
            }
            if (element.getName().getLocalPart().equals("Sink")) {
                this.m_current_descriptor.addSink(this.getAttribute(element, "sig"));
            }
            if (element.getName().getLocalPart().equals("associated_methods")) {
                this.m_current_descriptor = this.m_descriptors.get(this.getAttribute(element, "type"));
            }
            if (element.getName().getLocalPart().equals("descriptor_method")) {
                if (!this.m_routines.containsKey(this.getAttribute(element, "signature"))) {
                    this.m_routines.put(this.getAttribute(element, "signature"), new ValidationRoutine(this.getAttribute(element, "signature"), this.m_lang));
                }
                this.m_routines.get(this.getAttribute(element, "signature")).addDescriptor(this.m_current_descriptor);
            }
        }
        catch (BadMarkupException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
        return super.process(element);
    }

    @Override
    protected boolean process(EndElement element) {
        if (element.getName().getLocalPart().equals("Descriptor")) {
            this.m_descriptors.put(this.m_current_descriptor.getDescriptorName(), this.m_current_descriptor);
        }
        return super.process(element);
    }

    public HashMap<String, Descriptor> getDescriptors() {
        return this.m_descriptors;
    }

    public HashMap<String, ValidationRoutine> getValidationRoutines() {
        return this.m_routines;
    }
}

