/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.data.file.save;

import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.vdb.exception.BadRuleException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.data.file.save.RuleWriter;
import com.ibm.appscan.vdb.rule.Rule;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public abstract class BaseRuleWriter {
    private RuleWriter m_rule_writer;
    private DocumentBuilder m_builder;
    private Transformer m_transformer;

    public BaseRuleWriter() throws VDBGeneralException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.m_builder = factory.newDocumentBuilder();
            TransformerFactory transform_factory = TransformerFactory.newInstance();
            this.m_transformer = transform_factory.newTransformer();
            this.m_transformer.setOutputProperty("indent", "yes");
            this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.m_transformer.setOutputProperty("standalone", "yes");
        }
        catch (ParserConfigurationException e) {
            throw new VDBGeneralException("Issue initializing document writer {0}", e.getLocalizedMessage());
        }
        catch (TransformerConfigurationException tce) {
            throw new VDBGeneralException("Issue configuring the transformer: {0}", tce.getLocalizedMessage());
        }
    }

    protected abstract DOMWriter getDomWriter() throws VDBGeneralException;

    protected DocumentBuilder getBuilder() {
        return this.m_builder;
    }

    private RuleWriter getRuleWriter() throws VDBGeneralException {
        if (this.m_rule_writer == null) {
            this.m_rule_writer = new RuleWriter(this.getDomWriter());
        }
        return this.m_rule_writer;
    }

    public void writeRules(Collection<Rule> collection) throws VDBGeneralException {
        try {
            this.getDomWriter().beginElement("Rules");
            for (Rule r : collection) {
                try {
                    this.getRuleWriter().writeRule(r);
                }
                catch (BadRuleException e) {
                    throw new VDBGeneralException(e);
                }
            }
            this.getDomWriter().endElement();
            this.getDomWriter().write(this.m_transformer);
        }
        catch (TransformerException te) {
            throw new VDBGeneralException(te, "Transform issue during write of rules", new Object[0]);
        }
    }

    public void writeRules(Rule r) throws VDBGeneralException {
        try {
            this.getDomWriter().beginElement("Rules");
            try {
                this.getRuleWriter().writeRule(r);
            }
            catch (BadRuleException e) {
                throw new VDBGeneralException(e);
            }
            this.getDomWriter().endElement();
            this.getDomWriter().write(this.m_transformer);
        }
        catch (TransformerException te) {
            throw new VDBGeneralException(te, "Transform issue during write of rules", new Object[0]);
        }
    }
}

