/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.property;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.file.load.PropertyLoader;
import com.ibm.appscan.vdb.provider.data.file.save.PropertyWriter;
import com.ibm.appscan.vdb.provider.property.BasePropertyProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;

public class VdbPropertyProvider
extends BasePropertyProvider {
    private HashMap<Integer, String> m_prop_map = new HashMap();
    private HashMap<String, Integer> m_prop_id_map = new HashMap();
    private ArrayList<String> m_vulns = new ArrayList();
    private ArrayList<String> m_all_vulns = new ArrayList();
    private ArrayList<String> m_techs = new ArrayList();
    private ArrayList<String> m_mechs = new ArrayList();
    private ArrayList<String> m_props = new ArrayList();
    private int m_highest_id = 0;
    private PropertyWriter m_writer = new PropertyWriter();

    public VdbPropertyProvider() throws VDBGeneralException {
        PropertyLoader loader = new PropertyLoader(new File(CommonCore.getDirectoryLocator().getConfig(), "vdb_properties.xml"));
        try {
            loader.read();
            this.m_prop_map = loader.getPropertyMap();
            for (Integer id : this.m_prop_map.keySet()) {
                this.m_prop_id_map.put(this.m_prop_map.get(id), id);
                if (this.isVulnerability(this.m_prop_map.get(id))) {
                    if (!this.m_prop_map.get(id).contains("ABAP")) {
                        this.m_vulns.add(this.m_prop_map.get(id));
                    }
                    this.m_all_vulns.add(this.m_prop_map.get(id));
                    continue;
                }
                if (this.isTechnology(this.m_prop_map.get(id))) {
                    this.m_techs.add(this.m_prop_map.get(id));
                    continue;
                }
                if (this.isMechanism(this.m_prop_map.get(id))) {
                    this.m_mechs.add(this.m_prop_map.get(id));
                    continue;
                }
                this.m_props.add(this.m_prop_map.get(id));
            }
        }
        catch (FileNotFoundException e) {
            throw new VDBGeneralException("File not found: " + e.getLocalizedMessage(), new Object[0]);
        }
        catch (XMLStreamException xmle) {
            throw new VDBGeneralException("Xml parse exception: " + xmle.getLocalizedMessage(), new Object[0]);
        }
    }

    @Override
    public boolean addProperty(String property) throws VDBGeneralException {
        if (!this.m_prop_id_map.keySet().contains(property)) {
            ++this.m_highest_id;
            this.m_prop_id_map.put(property, this.m_highest_id);
            this.m_prop_map.put(this.m_highest_id, property);
            if (this.isVulnerability(property)) {
                this.m_vulns.add(property);
            } else if (this.isTechnology(property)) {
                this.m_techs.add(property);
            } else if (this.isMechanism(property)) {
                this.m_mechs.add(property);
            } else {
                this.m_props.add(property);
            }
            try {
                this.m_writer.write();
            }
            catch (BadMarkupException e) {
                throw new VDBGeneralException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<String> getVulnerabilities() throws VDBGeneralException {
        return this.m_vulns;
    }

    @Override
    public ArrayList<String> getAllVulnerabilities() throws VDBGeneralException {
        return this.m_all_vulns;
    }

    @Override
    public ArrayList<String> getMechanisms() throws VDBGeneralException {
        return this.m_mechs;
    }

    @Override
    public ArrayList<String> getTechnologies() throws VDBGeneralException {
        return this.m_techs;
    }

    @Override
    public ArrayList<String> getProperties() throws VDBGeneralException {
        return this.m_props;
    }

    @Override
    public int getPropertyId(String fqn) throws VDBGeneralException {
        if (fqn == null || fqn.length() == 0) {
            throw new VDBGeneralException("Id of a property cannot be null or an empty string", new Object[0]);
        }
        if (VdbProvider.isNumeric(fqn) && this.getPropertyFqn(Integer.parseInt(fqn)) != null) {
            return Integer.parseInt(fqn);
        }
        if (this.m_prop_id_map.get(fqn) != null) {
            return this.m_prop_id_map.get(fqn);
        }
        if (!fqn.startsWith("Vulnerability") && this.m_prop_id_map.get("Vulnerability." + fqn) != null) {
            return this.m_prop_id_map.get("Vulnerability." + fqn);
        }
        return 0;
    }

    @Override
    public String getPropertyFqn(int id) throws VDBGeneralException {
        if (!this.m_prop_map.containsKey(id)) {
            throw new VDBGeneralException("Property Map does not contain id:{0}", id);
        }
        return this.m_prop_map.get(id);
    }

    @Override
    public boolean isMechanism(int id) throws VDBGeneralException {
        if (this.m_prop_map.get(id) == null) {
            throw new VDBGeneralException("Invalid property {0}", id);
        }
        return this.isMechanism(this.m_prop_map.get(id));
    }

    @Override
    public boolean isTechnology(int id) throws VDBGeneralException {
        if (this.m_prop_map.get(id) == null) {
            throw new VDBGeneralException("Invalid technology {0}", id);
        }
        return this.isTechnology(this.m_prop_map.get(id));
    }

    @Override
    public boolean isVulnerability(int id) throws VDBGeneralException {
        if (this.m_prop_map.get(id) == null) {
            throw new VDBGeneralException("Invalid vulnerability {0}", id);
        }
        return this.isVulnerability(this.m_prop_map.get(id));
    }
}

