/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.provider.rest;

import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.rest.BaseRestClient;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;

public class VulnerabilityRestClient
extends BaseRestClient {
    private String m_prop_base = "properties/";

    protected VulnerabilityRestClient(String host, String port, boolean secure) {
        super(host, port, secure);
    }

    public boolean addProperty(String prop) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_prop_base + "add", "POST");
            conn.addRequestProperty("Cookie", prop);
            if (conn.getResponseCode() == 200) {
                return true;
            }
            if (conn.getResponseCode() == 400) {
                throw new VDBGeneralException("Rest server error during upload", new Object[0]);
            }
            if (conn.getResponseCode() == 404) {
                return false;
            }
            throw new VDBGeneralException("Server error during upload: " + conn.getResponseCode(), new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public ArrayList<String> getVulnerabilities() throws VDBGeneralException {
        return this.getPropHelper("vulns");
    }

    public ArrayList<String> AllgetVulnerabilities() throws VDBGeneralException {
        return this.getPropHelper("all_vulns");
    }

    public ArrayList<String> getProperties() throws VDBGeneralException {
        return this.getPropHelper("props");
    }

    public ArrayList<String> getTechnologies() throws VDBGeneralException {
        return this.getPropHelper("techs");
    }

    public ArrayList<String> getMechanisms() throws VDBGeneralException {
        return this.getPropHelper("mechs");
    }

    private ArrayList<String> getPropHelper(String type) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_prop_base + type, "GET");
            ArrayList<String> ret = new ArrayList<String>();
            if (conn.getResponseCode() == 200) {
                for (String s : this.splitResponse(conn, "#")) {
                    ret.add(s);
                }
                return ret;
            }
            throw new VDBGeneralException("Unable to retrieve " + type, new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    public int getVulnerabilityId(String fqn) throws VDBGeneralException {
        block5: {
            try {
                HttpURLConnection conn = this.getConnection(this.m_prop_base + "fqn/" + fqn, "GET");
                String ret = null;
                if (conn.getResponseCode() == 200) {
                    ret = this.getResponse(conn);
                    if (VdbProvider.isNumeric(ret)) {
                        if (Integer.parseInt(ret) == 0) {
                            throw new VDBGeneralException("Vuln fqn is invalid:" + fqn, new Object[0]);
                        }
                        return Integer.parseInt(ret);
                    }
                    break block5;
                }
                throw new VDBGeneralException("Response was non numeric:" + ret, new Object[0]);
            }
            catch (IOException e) {
                throw new VDBGeneralException(e);
            }
        }
        return 0;
    }

    public String getVulnerabilityFqn(int id) throws VDBGeneralException {
        try {
            HttpURLConnection conn = this.getConnection(this.m_prop_base + "id/" + Integer.toString(id), "GET");
            String ret = null;
            if (conn.getResponseCode() == 200) {
                String fqn = this.getResponse(conn);
                if (fqn.equals("")) {
                    throw new VDBGeneralException("Invalid id:0", new Object[0]);
                }
                return fqn;
            }
            throw new VDBGeneralException("Response was non numeric:" + ret, new Object[0]);
        }
        catch (IOException e) {
            throw new VDBGeneralException(e);
        }
    }

    @Override
    protected String getApplicationBase() {
        return "sast";
    }
}

