/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.ssa;

import com.ibm.wala.cast.ir.ssa.MultiReturnValueInvokeInstruction;
import com.ibm.wala.cast.js.ssa.JSInstructionFactory;
import com.ibm.wala.cast.js.ssa.JSInstructionVisitor;
import com.ibm.wala.cast.js.ssa.Util;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;

public class JavaScriptInvoke
extends MultiReturnValueInvokeInstruction {
    private final int[] params;
    private int function;

    public JavaScriptInvoke(int iindex, int function, int[] results, int[] params, int exception, CallSiteReference site) {
        super(iindex, results, exception, site);
        this.function = function;
        this.params = params;
    }

    public JavaScriptInvoke(int iindex, int function, int result, int[] params, int exception, CallSiteReference site) {
        this(iindex, function, new int[]{result}, params, exception, site);
    }

    public JavaScriptInvoke(int iindex, int function, int[] params, int exception, CallSiteReference site) {
        this(iindex, function, null, params, exception, site);
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        int fn = this.function;
        int[] newParams = this.params;
        if (uses != null) {
            int i = 0;
            fn = uses[i++];
            newParams = new int[this.params.length];
            for (int j = 0; j < newParams.length; ++j) {
                newParams[j] = uses[i++];
            }
        }
        int[] newLvals = new int[this.results.length];
        System.arraycopy(this.results, 0, newLvals, 0, this.results.length);
        int newExp = this.exception;
        if (defs != null) {
            int i = 0;
            if (this.getNumberOfReturnValues() > 0) {
                newLvals[0] = defs[i++];
            }
            newExp = defs[i++];
            for (int j = 1; j < this.getNumberOfReturnValues(); ++j) {
                newLvals[j] = defs[i++];
            }
        }
        return ((JSInstructionFactory)insts).Invoke(this.iindex, fn, newLvals, newParams, newExp, this.site);
    }

    public int getNumberOfUses() {
        return this.getNumberOfParameters();
    }

    public String toString(SymbolTable symbolTable) {
        StringBuffer s = new StringBuffer();
        if (this.getNumberOfReturnValues() > 0) {
            s.append(this.getValueString(symbolTable, this.getReturnValue(0)));
            s.append(" = ");
        }
        if (this.site.getDeclaredTarget().equals((Object)JavaScriptMethods.ctorReference)) {
            s.append("construct ");
        } else if (this.site.getDeclaredTarget().equals((Object)JavaScriptMethods.dispatchReference)) {
            s.append("dispatch ");
        } else {
            s.append("invoke ");
        }
        s.append(this.getValueString(symbolTable, this.function));
        if (this.site != null) {
            s.append("@").append(this.site.getProgramCounter());
        }
        if (this.params != null) {
            if (this.params.length > 0) {
                s.append(" ").append(this.getValueString(symbolTable, this.params[0]));
            }
            for (int i = 1; i < this.params.length; ++i) {
                s.append(",").append(this.getValueString(symbolTable, this.params[i]));
            }
        }
        if (this.exception == -1) {
            s.append(" exception: NOT MODELED");
        } else {
            s.append(" exception:").append(this.getValueString(symbolTable, this.exception));
        }
        return s.toString();
    }

    public void visit(SSAInstruction.IVisitor v) {
        assert (v instanceof JSInstructionVisitor);
        ((JSInstructionVisitor)v).visitJavaScriptInvoke(this);
    }

    public int getNumberOfParameters() {
        if (this.params == null) {
            return 1;
        }
        return this.params.length + 1;
    }

    public int getUse(int j) {
        if (j == 0) {
            return this.function;
        }
        if (j <= this.params.length) {
            return this.params[j - 1];
        }
        return super.getUse(j);
    }

    public int getFunction() {
        return this.function;
    }

    public Collection<TypeReference> getExceptionTypes() {
        return Util.typeErrorExceptions();
    }

    public int hashCode() {
        return this.site.hashCode() * this.function * 7529;
    }
}

