/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.translator;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstControlFlowRecorder;
import com.ibm.wala.cast.tree.impl.CAstSourcePositionRecorder;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public interface JavaScriptTranslatorToCAst
extends TranslatorToCAst {

    public static class MemberDestructuringContext<C extends WalkContext<C, T>, T>
    extends DelegatingContext<C, T> {
        private final Set<T> baseFor = new HashSet<T>();
        private int operationIndex;
        private boolean foundBase = false;

        protected MemberDestructuringContext(C parent, T initialBaseFor, int operationIndex) {
            super(parent);
            this.baseFor.add(initialBaseFor);
            this.operationIndex = operationIndex;
        }

        @Override
        public int setOperation(T node) {
            if (this.baseFor.contains(node)) {
                this.foundBase = true;
                return this.operationIndex;
            }
            return -1;
        }

        @Override
        public boolean foundMemberOperation(T node) {
            return this.foundBase;
        }

        @Override
        public void copyOperation(T from, T to) {
            if (this.baseFor.contains(from)) {
                this.baseFor.add(to);
            }
        }
    }

    public static class LoopContext<C extends WalkContext<C, T>, T>
    extends BreakContext<C, T> {
        private final T continueTo;

        protected LoopContext(C parent, T breakTo, T continueTo, String label) {
            super(parent, breakTo, label);
            this.continueTo = continueTo;
        }

        public T getContinueFor(String l) {
            return (T)(l == null || l.equals(this.label) ? this.continueTo : super.getContinueFor(l));
        }
    }

    public static class BreakContext<C extends WalkContext<C, T>, T>
    extends DelegatingContext<C, T> {
        private final T breakTarget;
        protected final String label;

        protected BreakContext(C parent, T breakTarget, String label) {
            super(parent);
            this.breakTarget = breakTarget;
            this.label = label;
        }

        public T getBreakFor(String l) {
            return (T)(l == null || l.equals(this.label) ? this.breakTarget : super.getBreakFor(l));
        }
    }

    public static class TryCatchContext<C extends WalkContext<C, T>, T>
    extends DelegatingContext<C, T> {
        private final CAstNode catchNode;

        protected TryCatchContext(C parent, CAstNode catchNode) {
            super(parent);
            this.catchNode = catchNode;
        }

        @Override
        public CAstNode getCatchTarget() {
            return this.catchNode;
        }
    }

    public static class ScriptContext<C extends WalkContext<C, T>, T>
    extends FunctionContext<C, T> {
        private final String script;

        ScriptContext(C parent, T s, String script) {
            super(parent, s);
            this.script = script;
        }

        @Override
        public String script() {
            return this.script;
        }
    }

    public static class FunctionContext<C extends WalkContext<C, T>, T>
    extends DelegatingContext<C, T> {
        private final T topNode;
        private final CAstSourcePositionRecorder pos = new CAstSourcePositionRecorder();
        private final CAstControlFlowRecorder cfg = new CAstControlFlowRecorder((CAstSourcePositionMap)this.pos);
        private final Map<CAstNode, Collection<CAstEntity>> scopedEntities = HashMapFactory.make();
        private final Vector<CAstNode> initializers = new Vector();

        protected FunctionContext(C parent, T s) {
            super(parent);
            this.topNode = s;
        }

        @Override
        public T top() {
            return this.topNode;
        }

        @Override
        public CAstNode getCatchTarget() {
            return CAstControlFlowMap.EXCEPTION_TO_EXIT;
        }

        public void addScopedEntity(CAstNode construct, CAstEntity e) {
            if (!this.scopedEntities.containsKey(construct)) {
                this.scopedEntities.put(construct, new HashSet(1));
            }
            this.scopedEntities.get(construct).add(e);
        }

        public Map<CAstNode, Collection<CAstEntity>> getScopedEntities() {
            return this.scopedEntities;
        }

        @Override
        public void addNameDecl(CAstNode v) {
            this.initializers.add(v);
        }

        @Override
        public Collection<CAstNode> getNameDecls() {
            return this.initializers;
        }

        public CAstControlFlowRecorder cfg() {
            return this.cfg;
        }

        public CAstSourcePositionRecorder pos() {
            return this.pos;
        }
    }

    public static class DelegatingContext<C extends WalkContext<C, T>, T>
    extends TranslatorToCAst.DelegatingContext<C, T>
    implements WalkContext<C, T> {
        protected DelegatingContext(C parent) {
            super(parent);
        }

        @Override
        public String script() {
            return ((WalkContext)this.parent).script();
        }

        @Override
        public T top() {
            return ((WalkContext)this.parent).top();
        }

        @Override
        public void addNameDecl(CAstNode n) {
            ((WalkContext)this.parent).addNameDecl(n);
        }

        @Override
        public Collection<CAstNode> getNameDecls() {
            return ((WalkContext)this.parent).getNameDecls();
        }

        @Override
        public CAstNode getCatchTarget() {
            return ((WalkContext)this.parent).getCatchTarget();
        }

        @Override
        public int setOperation(T node) {
            return ((WalkContext)this.parent).setOperation(node);
        }

        @Override
        public boolean foundMemberOperation(T node) {
            return ((WalkContext)this.parent).foundMemberOperation(node);
        }

        @Override
        public void copyOperation(T from, T to) {
            ((WalkContext)this.parent).copyOperation(from, to);
        }
    }

    public static class RootContext<C extends WalkContext<C, T>, T>
    extends TranslatorToCAst.RootContext<C, T>
    implements WalkContext<C, T> {
        @Override
        public String script() {
            return null;
        }

        @Override
        public T top() {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public void addNameDecl(CAstNode v) {
            Assertions.UNREACHABLE();
        }

        @Override
        public Collection<CAstNode> getNameDecls() {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public CAstNode getCatchTarget() {
            Assertions.UNREACHABLE();
            return null;
        }

        @Override
        public int setOperation(T node) {
            return -1;
        }

        @Override
        public boolean foundMemberOperation(T node) {
            return false;
        }

        @Override
        public void copyOperation(T from, T to) {
            Assertions.UNREACHABLE();
        }
    }

    public static interface WalkContext<C extends WalkContext<C, T>, T>
    extends TranslatorToCAst.WalkContext<C, T> {
        public String script();

        public T top();

        public void addNameDecl(CAstNode var1);

        public Collection<CAstNode> getNameDecls();

        public CAstNode getCatchTarget();

        public int setOperation(T var1);

        public boolean foundMemberOperation(T var1);

        public void copyOperation(T var1, T var2);
    }
}

