/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.commands;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.GetReportHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.json.JSONException;

public class GetReportCommand
extends Command {
    private GetReportHandler m_handler = new GetReportHandler();

    public GetReportCommand() {
    }

    public GetReportCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.getMessage("command.report.namespace", new Object[0]));
        this.setName("get_report");
        this.setDescription(Messages.getMessage("command.getreport.description", new Object[0]));
        this.setOptions(this.buildOptions(), false);
        this.enableLogLevelOptions();
    }

    public Command createCommand(String[] args) {
        return new GetReportCommand(args);
    }

    public int getLogLevel(CommandLine cmd) {
        if (this.getEnableLogLevels() && this.getDebug() && cmd.hasOption("X")) {
            return 0;
        }
        return 1;
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        if (cmd.hasOption("applyPolicies")) {
            this.m_handler.setApplyPolicies(true);
        }
        if (cmd.hasOption("dtoc")) {
            this.m_handler.setTableOfContent(false);
        }
        if (cmd.hasOption("ds")) {
            this.m_handler.setSummary(false);
        }
        try {
            this.m_handler.getResult(cmd.getOptionValue("i"), cmd.getOptionValue("t"), cmd.getOptionValue("s"), cmd.getOptionValue("d"), cmd.getOptionValue("f"), cmd.getOptionValue("rt"), cmd.getOptionValue("title"), cmd.getOptionValue("locale"));
        }
        catch (AppScanException | JSONException e) {
            CommonCLICore.getLogManager().log(new Message(e));
            CommonCLICore.getIOConsole().println(new Message(e));
        }
    }

    protected Options getVisibleOptions(Options options) {
        Options visibleOptions = new Options();
        for (Object obj : options.getOptions()) {
            Option opt = (Option)obj;
            if ("title".equals(opt.getOpt())) continue;
            visibleOptions.addOption(opt);
        }
        return visibleOptions;
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.reporttype.argument", new Object[0]));
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)Messages.getMessage("option.reporttype.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.reporttarget.argument", new Object[0]));
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)Messages.getMessage("option.reporttarget.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.reportscope.argument", new Object[0]));
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)Messages.getMessage("option.reportscope.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.extension.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.extension.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("command.getresult.path.name", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("command.getresult.path.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.regreport.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.regreport.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"rt"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.reporttitle.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.reporttitle.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"title"));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withArgName((String)Messages.getMessage("option.reportlocale.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.reportlocale.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"locale"));
        OptionBuilder.withDescription((String)Messages.getMessage("option.applypolicies.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"applyPolicies"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)Messages.getMessage("option.disable.tableofcontent.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.disable.tableofcontent.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"dtoc"));
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withArgName((String)Messages.getMessage("option.disable.summary.argument", new Object[0]));
        OptionBuilder.withDescription((String)Messages.getMessage("option.disable.summary.description", new Object[0]));
        options.addOption(OptionBuilder.create((String)"ds"));
        return options;
    }
}

