/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.cloud.handlers;

import com.ibm.appscan.cli.cloud.Messages;
import com.ibm.appscan.cli.cloud.handlers.SAHandler;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.StringUtil;
import java.io.IOException;

public class CancelHandler
extends SAHandler {
    public void cancel(String scanId) throws AppScanException {
        this.doCancel(StringUtil.getCleanUuid((String)scanId));
    }

    private void doCancel(String scanId) {
        this.setProgressAdapter((IProgress)new ProgressAdapter());
        try {
            if (this.isTokenExpired()) {
                return;
            }
            int responseCode = this.deleteScan(scanId);
            if (responseCode == 204) {
                CommonCLICore.getIOConsole().println(Messages.getMessage("job.cancel.success", new Object[0]));
            } else if (responseCode == 400) {
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("err.invalid.jobid", new Object[0])));
            } else {
                this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.cancel.error", new Object[0])));
            }
        }
        catch (IOException e) {
            this.getProgressAdapter().setStatus(new Message((Throwable)e));
            this.getProgressAdapter().setStatus(new Message(4, Messages.getMessage("job.cancel.error", new Object[0])));
        }
    }
}

