/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.translator.repository;

import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IPositionSetTerm;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionTerm;
import com.ibm.wala.samso.m2lstr.IPositionVariable;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.translator.SolverContext;
import com.ibm.wala.samso.translator.repository.M2LConstraint;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.RangeCondition;
import com.ibm.wala.stringAnalysis.grammar.ConditionedInvocationSymbol;

public class IndexOfConstraint2
extends M2LConstraint {
    private final int strIndex;
    private final int searchStrIndex;
    private final int beginIndex;

    public IndexOfConstraint2(int strIndex, int searchStrIndex, int beginIndex) {
        super(strIndex);
        this.strIndex = strIndex;
        this.searchStrIndex = searchStrIndex;
        this.beginIndex = beginIndex;
    }

    public IndexOfConstraint2(int strIndex, int searchStrIndex) {
        this(strIndex, searchStrIndex, -1);
    }

    private static IFormula miss(IPositionTerm p, IPositionSetTerm P, IExtendedFormulaFactory ffactory) {
        return null;
    }

    public static IFormula constraintFor(IPrimitiveCondition cond, IPositionTerm q, IPositionTerm p, IPositionSetTerm P, IExtendedFormulaFactory ffactory) {
        if (cond instanceof RangeCondition) {
            RangeCondition range = (RangeCondition)cond;
            if (range.boundary < 0L) {
                return IndexOfConstraint2.miss(p, P, ffactory);
            }
            IFormula pos1 = ffactory.createPos((int)range.boundary, q, P);
            IFormula pos2 = null;
            switch (range.op) {
                case LT: {
                    pos2 = ffactory.createIsLT(p, q);
                    break;
                }
                case LE: {
                    pos2 = ffactory.createOr(ffactory.createIsLT(p, q), ffactory.createPositionEqual(p, q));
                    break;
                }
                case GT: {
                    pos2 = ffactory.createIsGT(p, q);
                    break;
                }
                case GE: {
                    pos2 = ffactory.createOr(ffactory.createIsGT(p, q), ffactory.createPositionEqual(p, q));
                    break;
                }
                case EQ: {
                    pos2 = ffactory.createPositionEqual(p, q);
                    break;
                }
                case NE: {
                    pos2 = ffactory.createNot(ffactory.createPositionEqual(p, q));
                }
            }
            if (pos2 != null) {
                IFormula pos = ffactory.createAnd(pos1, pos2);
                return pos;
            }
        } else {
            if (cond instanceof CaseCondition) {
                CaseCondition c = (CaseCondition)cond;
                if (c.label < 0) {
                    return IndexOfConstraint2.miss(q, P, ffactory);
                }
                IFormula pos1 = ffactory.createPos(c.label, q, P);
                IFormula pos2 = ffactory.createPositionEqual(p, q);
                IFormula pos = ffactory.createAnd(pos1, pos2);
                return pos;
            }
            if (cond instanceof NotCaseCondition) {
                NotCaseCondition c = (NotCaseCondition)cond;
                if (c.label < 0) {
                    return IndexOfConstraint2.miss(q, P, ffactory);
                }
                IFormula pos1 = ffactory.createNot(ffactory.createPos(c.label, q, P));
                IFormula pos2 = ffactory.createPositionEqual(p, q);
                IFormula pos = ffactory.createAnd(pos1, pos2);
                return pos;
            }
        }
        return ffactory.createTrue();
    }

    public static Condition inferCondition(IPrimitiveCondition cond) {
        if (cond instanceof RangeCondition) {
            RangeCondition range = (RangeCondition)cond;
            switch (range.op) {
                case LT: {
                    if (range.boundary > 0L) break;
                    return Condition.NOT_EXISTS;
                }
                case LE: {
                    if (range.boundary >= 0L) break;
                    return Condition.NOT_EXISTS;
                }
                case GT: {
                    if (range.boundary < -1L) break;
                    return Condition.EXISTS;
                }
                case GE: {
                    if (range.boundary < 0L) break;
                    return Condition.EXISTS;
                }
                case EQ: {
                    if (range.boundary >= 0L) {
                        return Condition.EXISTS;
                    }
                    return Condition.NOT_EXISTS;
                }
                case NE: {
                    if (range.boundary >= 0L) break;
                    return Condition.EXISTS;
                }
            }
        } else {
            if (cond instanceof CaseCondition) {
                CaseCondition c = (CaseCondition)cond;
                if (c.label >= 0) {
                    return Condition.EXISTS;
                }
                return Condition.NOT_EXISTS;
            }
            if (cond instanceof NotCaseCondition) {
                NotCaseCondition c = (NotCaseCondition)cond;
                if (c.label < 0) {
                    return Condition.EXISTS;
                }
            }
        }
        return Condition.UNKNOWN;
    }

    public IFormula instantiate2(IExtendedFormulaFactory factory, IPositionVariable n, IPositionSetVariable R, IPredicate ... pred) {
        if (this.rule.getRight(0) instanceof ConditionedInvocationSymbol) {
            IPositionVariable q;
            ConditionedInvocationSymbol invoke = (ConditionedInvocationSymbol)this.rule.getRight(0);
            IPrimitiveCondition cond = invoke.getCondition();
            IFormula c = IndexOfConstraint2.constraintFor(cond, q = factory.createPositionVariable(), n, R, factory);
            if (c == null) {
                return this.instantiate1(factory, n, R, pred);
            }
            IFormula f = factory.createExists(q, c);
            IPositionSetVariable P = factory.createPositionSetVariable();
            return this.parse(factory, "ex2 $P: $predSearch($P) & substr($P,$R) & " + f + ";", "R", R.getName(), "P", P.getName(), "predSearch", pred[this.searchStrIndex].getName());
        }
        return factory.createTrue();
    }

    public IFormula instantiate1(IExtendedFormulaFactory factory, IPositionVariable _n, IPositionSetVariable R, IPredicate ... pred) {
        Condition existPos = Condition.UNKNOWN;
        if (this.rule.getRight(0) instanceof ConditionedInvocationSymbol) {
            ConditionedInvocationSymbol invoke = (ConditionedInvocationSymbol)this.rule.getRight(0);
            IPrimitiveCondition cond = invoke.getCondition();
            existPos = IndexOfConstraint2.inferCondition(cond);
        }
        IPositionSetVariable P = factory.createPositionSetVariable();
        switch (existPos) {
            case EXISTS: {
                return this.parse(factory, "ex2 $P: $predSearch($P) & substr($P,$R);", "R", R.getName(), "P", P.getName(), "predSearch", pred[this.searchStrIndex].getName());
            }
            case NOT_EXISTS: {
                ISymbol s = this.getParam(this.searchStrIndex);
                if (s instanceof StringSymbol) {
                    StringSymbol ssym = (StringSymbol)s;
                    String str = ssym.getName();
                    IFormula isStr = factory.createIsStr(str, P);
                    IFormula isNotStr = factory.createNot(isStr);
                    return this.parse(factory, "all2 $P: substr($P,$R) => " + isNotStr + ";", "R", R.getName(), "P", P.getName());
                }
                if (s instanceof NumberSymbol) {
                    NumberSymbol num = (NumberSymbol)s;
                    String str = Character.toString(num.charValue());
                    IFormula isStr = factory.createIsStr(str, P);
                    IFormula isNotStr = factory.createNot(isStr);
                    return this.parse(factory, "all2 $P: substr($P,$R) => " + isNotStr + ";", "R", R.getName(), "P", P.getName());
                }
                return factory.createTrue();
            }
        }
        return factory.createTrue();
    }

    @Override
    public IFormula instantiate(IExtendedFormulaFactory factory, IPositionVariable n, IPositionSetVariable R, IPredicate ... pred) {
        return this.instantiate2(factory, n, R, pred);
    }

    @Override
    public boolean isIndexFunction(SolverContext ctx) {
        return true;
    }

    @Override
    public boolean isIndexParameter(int paramN, SolverContext ctx) {
        return paramN == this.beginIndex;
    }

    public static enum Condition {
        UNKNOWN,
        NOT_EXISTS,
        EXISTS;

    }
}

