/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.translator.repository;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.IPositionVariable;
import com.ibm.wala.samso.m2lstr.IPredicate;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.repository.M2LTranslator;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class JavaMatcherTemplate
extends M2LTranslator {
    private static final String matcherSignature = "java.util.regex.Pattern.matcher(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;";
    private IDeclarationSet matcher = null;

    public SimpleGrammar prepare(IConstraintSolver<IDeclarationSet> solver, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar grammar) {
        return super.prepare(solver, funcName, recv, params, rule, grammar);
    }

    private static SSAAbstractInvokeInstruction findMatcher(SSAAbstractInvokeInstruction invoke, CGNode node) {
        int matcher = invoke.getReceiver();
        SSAInstruction mi = node.getDU().getDef(matcher);
        if (!(mi instanceof SSAAbstractInvokeInstruction)) {
            return null;
        }
        SSAAbstractInvokeInstruction minvoke = (SSAAbstractInvokeInstruction)mi;
        if (!minvoke.getDeclaredTarget().getSignature().equals(matcherSignature)) {
            return null;
        }
        return minvoke;
    }

    @Override
    public IDeclarationSet translate(IDeclarationSet g) throws TranslationException {
        CGNode node;
        IExtendedFormulaFactory ffactory = this.getFormulaFactory((IConstraintSolver<IDeclarationSet>)this.solver);
        InvocationSymbol invokeSym = (InvocationSymbol)this.rule.getRight(0);
        if (!(invokeSym.getInstruction() instanceof SSAAbstractInvokeInstruction)) {
            return DeclarationSets.createAny(ffactory);
        }
        SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)invokeSym.getInstruction();
        SSAAbstractInvokeInstruction minvoke = JavaMatcherTemplate.findMatcher(invoke, node = invokeSym.getCGNode());
        if (minvoke == null) {
            return DeclarationSets.createAny(ffactory);
        }
        for (IProductionRule r : this.grammar.getRules()) {
            InvocationSymbol is;
            SSAInstruction isInst;
            ISymbol s;
            List l = r.getRight();
            if (l.isEmpty() || !((s = (ISymbol)l.get(0)) instanceof InvocationSymbol) || (isInst = (is = (InvocationSymbol)s).getInstruction()) == null || !isInst.equals((Object)minvoke)) continue;
            ISymbol pat = is.getReceiver();
            if (pat instanceof IVariable) {
                Collection<String> strs;
                try {
                    strs = this.getConstantStrings((ISymbol)((IVariable)pat), Integer.MAX_VALUE);
                }
                catch (IllegalGrammarException e) {
                    strs = null;
                }
                if (strs == null) {
                    this.matcher = (IDeclarationSet)this.solver.solve(this.grammar, (IVariable)pat);
                } else {
                    HashSet<IDeclarationSet> decls = new HashSet<IDeclarationSet>();
                    if (strs != null && !strs.isEmpty()) {
                        for (String str : strs) {
                            IDeclarationSet declSet = DeclarationSets.createDeclarationSetForRegexp(str, ffactory);
                            decls.add(declSet);
                        }
                        this.matcher = DeclarationSets.createUnion(decls, ffactory);
                    }
                }
            } else if (pat instanceof StringSymbol) {
                StringSymbol ssym = (StringSymbol)pat;
                this.matcher = DeclarationSets.createDeclarationSetForRegexp(ssym.getName(), this.getFormulaFactory((IConstraintSolver<IDeclarationSet>)this.solver));
            }
            if (this.matcher == null) continue;
            g.addAll(this.matcher);
            return super.translate(g);
        }
        return DeclarationSets.createAny(ffactory);
    }

    @Override
    public IFormula instantiate(IExtendedFormulaFactory factory, IPositionVariable n, IPositionSetVariable R, IPredicate ... pred) {
        pred[0] = this.matcher.getTarget();
        return this.instantiate(factory, n, R, this.matcher, pred);
    }

    protected static Collection<IVariable> getConstraintTarget(SSAAbstractInvokeInstruction invoke, ISymbolFactory<IDeclarationSet> symFactory, ISSABasicBlock bb, TranslationContext ctx, int useVN) {
        SSAAbstractInvokeInstruction minvoke = JavaMatcherTemplate.findMatcher(invoke, ctx.getCGNode());
        if (minvoke == null) {
            return null;
        }
        int str = minvoke.getUse(useVN);
        IVariable v = symFactory.createValueNumberVariable(str, ctx.getCGNode(), ctx.getCallGraph());
        return Collections.singleton(v);
    }

    public abstract IFormula instantiate(IExtendedFormulaFactory var1, IPositionVariable var2, IPositionSetVariable var3, IDeclarationSet var4, IPredicate ... var5);
}

