/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveConditionVisitor;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collection;

public class RangeCondition
implements IPrimitiveCondition {
    public final int var;
    public final long boundary;
    public final Operator op;
    private int hashCode = 0;

    public RangeCondition(int var, long boundary, Operator op) {
        this.var = var;
        this.boundary = boundary;
        this.op = op;
    }

    @Override
    public IPrimitiveCondition inverse() {
        Operator iop;
        switch (this.op) {
            case GT: {
                iop = Operator.LE;
                break;
            }
            case GE: {
                iop = Operator.LT;
                break;
            }
            case LT: {
                iop = Operator.GE;
                break;
            }
            case LE: {
                iop = Operator.GT;
                break;
            }
            case EQ: {
                iop = Operator.NE;
                break;
            }
            case NE: {
                iop = Operator.EQ;
                break;
            }
            default: {
                iop = null;
                Assertions.UNREACHABLE();
            }
        }
        return new RangeCondition(this.var, this.boundary, iop);
    }

    @Override
    public boolean isContrary(Collection<IPrimitiveCondition> conditions) {
        return false;
    }

    @Override
    public void visit(IPrimitiveConditionVisitor visitor) {
        visitor.onRange(this);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)this.boundary;
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            this.hashCode = result = 31 * result + this.var;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeCondition other = (RangeCondition)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (this.boundary != other.boundary) {
            return false;
        }
        if (this.op == null ? other.op != null : !this.op.equals((Object)other.op)) {
            return false;
        }
        return this.var == other.var;
    }

    public String toString() {
        return this.op.toString() + "(" + this.var + "," + this.boundary + ")";
    }

    public static enum Operator {
        GT,
        LT,
        GE,
        LE,
        EQ,
        NE;

    }
}

