/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.ssa;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.stringAnalysis.ssa.AbstractSSAConversion;
import com.ibm.wala.stringAnalysis.ssa.LiveAnalysis;
import com.ibm.wala.stringAnalysis.ssa.SSAConversionException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class SSAConversion
extends AbstractSSAConversion {
    public static boolean DEBUG = false;
    public static boolean DEBUG_UNDO = false;
    public static boolean DEBUG_NAMES = false;
    public static boolean DUMP = false;
    private final IR ir;
    private int nextSSAValue;
    private final SymbolTable symtab;
    private final LiveAnalysis.Result liveness;
    private IR.SSA2LocalMap computedLocalMap;
    private final Map<Object, CopyPropagationRecord> copyPropagationMap;
    private final Stack<CopyPropagationRecord>[] R;
    private IUndoSSAConversion undoSSAConversion;
    private IRedoSSAConversion redoSSAConversion;

    private void addUndoAddPhi(SSACFG.BasicBlock bb, SSAPhiInstruction phi) {
        this.undoSSAConversion = new UndoAddPhi(bb, phi, this.undoSSAConversion);
    }

    private void addRedoAddPhi(SSACFG.BasicBlock bb, int index) {
        this.redoSSAConversion = new RedoAddPhi(bb, index, bb.getPhiForLocal(index), this.redoSSAConversion);
    }

    private void addUndoRewriteInstruction(int index) {
        this.undoSSAConversion = new UndoRewriteInstruction(this.instructions, index, this.instructions[index], this.undoSSAConversion);
    }

    private void addRedoRewriteInstruction(int index) {
        this.redoSSAConversion = new RedoRewriteInstruction(this.instructions, index, this.instructions[index], this.redoSSAConversion);
    }

    public void undoCopyPropagation(IR ir, int instruction, int use) {
        this.undoCopyPropagation(instruction, use);
    }

    public void copyUse(IR ir, int fromInst, int fromUse, int toInst, int toUse) {
        this.copyUse(fromInst, fromUse, toInst, toUse);
    }

    public String[] getLocalNames(int pc, int vn) {
        return this.ir.getLocalNames(pc, vn);
    }

    private void undoCopyPropagation(int instructionIndex, int useNumber) {
        UseRecord use;
        if (DEBUG_UNDO) {
            System.err.println("undoing for use #" + useNumber + " of inst #" + instructionIndex);
        }
        if (this.copyPropagationMap.containsKey(use = new UseRecord(instructionIndex, useNumber))) {
            this.copyPropagationMap.get(use).undo();
        }
    }

    private void copyUse(int fromInst, int fromUse, int toInst, int toUse) {
        UseRecord use = new UseRecord(fromInst, fromUse);
        if (this.copyPropagationMap.containsKey(use)) {
            this.copyPropagationMap.get(use).addUse(toInst, toUse);
        }
    }

    private CopyPropagationRecord topR(int v) {
        if (this.R[v] != null && !this.R[v].isEmpty()) {
            CopyPropagationRecord rec = this.R[v].peek();
            if (this.top(v) == rec.rhs) {
                return rec;
            }
        }
        return null;
    }

    @Override
    protected int getNumberOfDefs(SSAInstruction inst) {
        return inst.getNumberOfDefs();
    }

    @Override
    protected int getDef(SSAInstruction inst, int index) {
        return inst.getDef(index);
    }

    @Override
    protected int getNumberOfUses(SSAInstruction inst) {
        return inst.getNumberOfUses();
    }

    @Override
    protected int getUse(SSAInstruction inst, int index) {
        return inst.getUse(index);
    }

    @Override
    protected boolean isAssignInstruction(SSAInstruction inst) {
        return inst instanceof AssignInstruction;
    }

    @Override
    protected int getMaxValueNumber() {
        return this.symtab.getMaxValueNumber();
    }

    @Override
    protected boolean skip(int vn) {
        return vn == -1;
    }

    @Override
    protected boolean isLive(SSACFG.BasicBlock Y, int V) {
        return this.liveness.isLiveEntry((ISSABasicBlock)Y, V);
    }

    private void addPhi(SSACFG.BasicBlock BB, SSAPhiInstruction phi) {
        BB.addPhiForLocal(this.phiCounts[BB.getGraphNodeId()], phi);
        this.addUndoAddPhi(BB, phi);
        this.addRedoAddPhi(BB, this.phiCounts[BB.getGraphNodeId()]);
    }

    @Override
    protected void placeNewPhiAt(int value, SSACFG.BasicBlock Y) {
        int[] params = new int[this.CFG.getPredNodeCount((ISSABasicBlock)Y)];
        for (int i = 0; i < params.length; ++i) {
            params[i] = value;
        }
        SSAPhiInstruction phi = new SSAPhiInstruction(-1, value, params);
        if (DEBUG) {
            System.err.println("Placing " + phi + " at " + Y);
        }
        this.addPhi(Y, phi);
    }

    @Override
    protected SSAPhiInstruction getPhi(SSACFG.BasicBlock B, int index) {
        return B.getPhiForLocal(index);
    }

    @Override
    protected void setPhi(SSACFG.BasicBlock B, int index, SSAPhiInstruction inst) {
        B.addPhiForLocal(index, inst);
        this.addUndoAddPhi(B, inst);
        this.addRedoAddPhi(B, index);
    }

    @Override
    protected SSAPhiInstruction repairPhiDefs(SSAPhiInstruction phi, int[] newDefs) {
        return (SSAPhiInstruction)phi.copyForSSA(this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), newDefs, null);
    }

    @Override
    protected void repairPhiUse(SSACFG.BasicBlock BB, int phiIndex, int rvalIndex, int newRval) {
        SSAPhiInstruction phi = this.getPhi(BB, phiIndex);
        int[] newUses = new int[this.getNumberOfUses((SSAInstruction)phi)];
        for (int v = 0; v < newUses.length; ++v) {
            int newUse;
            int oldUse = this.getUse((SSAInstruction)phi, v);
            newUses[v] = newUse = v == rvalIndex ? newRval : oldUse;
            if (v != rvalIndex || this.topR(oldUse) == null) continue;
            this.topR(oldUse).addUse(BB.getGraphNodeId(), phiIndex, v);
        }
        phi.setValues(newUses);
    }

    @Override
    protected void pushAssignment(SSAInstruction inst, int index, int newRhs) {
        int lhs = this.getDef(inst, 0);
        int rhs = this.getUse(inst, 0);
        this.copyNames(rhs, lhs);
        CopyPropagationRecord rec = new CopyPropagationRecord(index, lhs, newRhs);
        this.R[lhs].push(rec);
        if (this.topR(rhs) != null) {
            this.topR(rhs).addChild(rec);
        }
    }

    @Override
    protected void repairInstructionUses(SSAInstruction inst, int index, int[] newUses) {
        for (int j = 0; j < this.getNumberOfUses(inst); ++j) {
            if (this.topR(this.getUse(inst, j)) == null) continue;
            this.topR(this.getUse(inst, j)).addUse(index, j);
        }
    }

    @Override
    protected void repairInstructionDefs(SSAInstruction inst, int index, int[] newDefs, int[] newUses) {
        this.addUndoRewriteInstruction(index);
        this.instructions[index] = inst.copyForSSA(this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), newDefs, newUses);
        this.addRedoRewriteInstruction(index);
    }

    @Override
    protected void popAssignment(SSAInstruction inst, int index) {
        this.addUndoRewriteInstruction(index);
        this.instructions[index] = null;
        this.addRedoRewriteInstruction(index);
    }

    @Override
    protected boolean isConstant(int valueNumber) {
        return this.symtab.isConstant(valueNumber);
    }

    @Override
    protected boolean skipRepair(SSAInstruction inst, int index) {
        if (!super.skipRepair(inst, index)) {
            return false;
        }
        if (index == -1) {
            return true;
        }
        return true;
    }

    private SSAConversion(IMethod M, IR ir, SSAOptions options) {
        super(ir, options);
        HashMap m;
        this.copyPropagationMap = m = HashMapFactory.make();
        this.ir = ir;
        this.symtab = ir.getSymbolTable();
        this.R = new Stack[ir.getSymbolTable().getMaxValueNumber() + 1];
        for (int i = 0; i < this.CFG.getNumberOfNodes(); ++i) {
            SSACFG.BasicBlock bb = this.CFG.getNode(i);
            if (!bb.hasPhi()) continue;
            int n = 0;
            Iterator X = bb.iteratePhis();
            while (X.hasNext()) {
                X.next();
                ++n;
            }
            this.phiCounts[i] = n;
        }
        this.nextSSAValue = ir.getNumberOfParameters() + 1;
        this.liveness = LiveAnalysis.perform(ir);
        this.undoSSAConversion = new UndoSSAConversion(null);
        this.redoSSAConversion = new RedoSSAConversion(null);
    }

    @Override
    protected int getNextNewValueNumber() {
        while (this.symtab.isConstant(this.nextSSAValue) || this.skip(this.nextSSAValue)) {
            ++this.nextSSAValue;
        }
        this.symtab.ensureSymbol(this.nextSSAValue);
        return this.nextSSAValue++;
    }

    private void copyNames(int to, int from) {
    }

    @Override
    protected void initializeVariables() {
        for (int V = 1; V <= this.getMaxValueNumber(); ++V) {
            if (this.skip(V)) continue;
            this.R[V] = new Stack();
        }
        int[] params = this.symtab.getParameterValueNumbers();
        for (int i = 0; i < params.length; ++i) {
            if (this.skip(params[i])) continue;
            this.S[params[i]].push(params[i]);
            this.valueMap[params[i]] = params[i];
        }
    }

    @Override
    protected void repairExit() {
    }

    @Override
    protected void fail(int v) {
        super.fail(v);
    }

    public IR.SSA2LocalMap getComputedLocalMap() {
        return this.computedLocalMap;
    }

    public void undoSSAConversion() {
        this.undoSSAConversion.undo();
    }

    public void redoSSAConversion() {
        this.redoSSAConversion.redo();
    }

    @Override
    public void perform() {
        super.perform();
    }

    private static IntSet valuesToConvert(IR ir) {
        SSAInstruction[] insts = ir.getInstructions();
        BitVectorIntSet foundOne = new BitVectorIntSet();
        BitVectorIntSet foundTwo = new BitVectorIntSet();
        for (int i = 0; i < insts.length; ++i) {
            SSAInstruction inst = insts[i];
            if (inst == null) continue;
            for (int j = 0; j < inst.getNumberOfDefs(); ++j) {
                int def = inst.getDef(j);
                if (def == -1) continue;
                if (foundOne.contains(def) || ir.getSymbolTable().isConstant(def) || def <= ir.getNumberOfParameters() || inst instanceof AssignInstruction) {
                    foundTwo.add(def);
                    continue;
                }
                foundOne.add(def);
            }
        }
        return foundTwo;
    }

    public static SSAConversion convert(IMethod M, IR ir, SSAOptions options) throws SSAConversionException {
        return SSAConversion.convert(M, ir, options, SSAConversion.valuesToConvert(ir));
    }

    public static SSAConversion convert(IMethod M, final IR ir, SSAOptions options, final IntSet values) throws SSAConversionException {
        try {
            if (DEBUG) {
                System.err.println("starting conversion for " + values);
                System.err.println(ir);
            }
            if (DEBUG_UNDO) {
                System.err.println(">>> starting " + ir.getMethod());
            }
            SSAConversion ssa = new SSAConversion(M, ir, options){
                final int limit;
                {
                    super(M, ir2, options);
                    this.limit = ir.getSymbolTable().getMaxValueNumber();
                }

                @Override
                protected boolean skip(int i) {
                    if (i >= 0 && i <= this.limit && !values.contains(i)) {
                        return true;
                    }
                    return super.skip(i);
                }
            };
            ssa.perform();
            if (DEBUG_UNDO) {
                System.err.println("<<< done " + ir.getMethod());
            }
            return ssa;
        }
        catch (RuntimeException e) {
            throw new SSAConversionException(e);
        }
        catch (Error e) {
            throw new SSAConversionException(e);
        }
    }

    private class CopyPropagationRecord {
        final int lhs;
        final int rhs;
        final int instructionIndex;
        final Set<Object> renamedUses = HashSetFactory.make((int)2);
        private final Set<CopyPropagationRecord> childRecords = HashSetFactory.make((int)1);

        public int hashCode() {
            return this.instructionIndex;
        }

        public boolean equals(Object o) {
            return o instanceof CopyPropagationRecord && this.instructionIndex == ((CopyPropagationRecord)o).instructionIndex;
        }

        private CopyPropagationRecord(int instructionIndex, int lhs, int rhs) {
            if (DEBUG_UNDO) {
                System.err.println("new copy record for instruction #" + instructionIndex + ", rhs value is " + rhs);
            }
            this.lhs = lhs;
            this.rhs = rhs;
            this.instructionIndex = instructionIndex;
        }

        private void addChild(CopyPropagationRecord rec) {
            if (DEBUG_UNDO) {
                System.err.println("(" + rec.instructionIndex + "," + rec.rhs + ") is a child of (" + this.instructionIndex + "," + this.rhs + ")");
            }
            this.childRecords.add(rec);
        }

        private void addUse(int instructionIndex, int use) {
            if (DEBUG_UNDO) {
                System.err.println("propagated use of (" + this.instructionIndex + "," + this.rhs + ") at use #" + use + " of instruction #" + instructionIndex);
            }
            UseRecord rec = new UseRecord(instructionIndex, use);
            SSAConversion.this.copyPropagationMap.put(rec, this);
            this.renamedUses.add(rec);
        }

        private void addUse(int BB, int phiNumber, int use) {
            PhiUseRecord rec = new PhiUseRecord(BB, phiNumber, use);
            SSAConversion.this.copyPropagationMap.put(rec, this);
            this.renamedUses.add(rec);
        }

        private SSAInstruction undo(SSAInstruction inst, int use, int val) {
            int c = SSAConversion.this.getNumberOfUses(inst);
            int[] newUses = new int[c];
            for (int i = 0; i < c; ++i) {
                newUses[i] = i == use ? val : SSAConversion.this.getUse(inst, i);
            }
            return inst.copyForSSA(SSAConversion.this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), null, newUses);
        }

        private void undo(int rhs) {
            int lhs = SSAConversion.this.symtab.newSymbol();
            SSAConversion.this.addUndoRewriteInstruction(this.instructionIndex);
            SSAConversion.this.instructions[this.instructionIndex] = new AssignInstruction(this.instructionIndex, lhs, rhs);
            SSAConversion.this.addRedoRewriteInstruction(this.instructionIndex);
            if (DEBUG_UNDO) {
                System.err.println("recreating assignment at " + this.instructionIndex + " as " + lhs + " = " + rhs);
            }
            for (Object x : this.renamedUses) {
                Object use;
                if (x instanceof UseRecord) {
                    use = (UseRecord)x;
                    int idx = ((UseRecord)use).instructionIndex;
                    SSAInstruction inst = SSAConversion.this.instructions[idx];
                    if (DEBUG_UNDO) {
                        System.err.println("Changing use #" + ((UseRecord)use).useNumber + " of inst #" + idx + " to val " + lhs);
                    }
                    if (((UseRecord)use).useNumber >= 0) {
                        SSAConversion.this.addUndoRewriteInstruction(idx);
                        SSAConversion.this.instructions[idx] = this.undo(inst, ((UseRecord)use).useNumber, lhs);
                        SSAConversion.this.addRedoRewriteInstruction(idx);
                    }
                    SSAConversion.this.copyPropagationMap.remove(use);
                    continue;
                }
                use = (PhiUseRecord)x;
                int bb = ((PhiUseRecord)use).BBnumber;
                int phi = ((PhiUseRecord)use).phiNumber;
                SSACFG.BasicBlock BB = SSAConversion.this.CFG.getNode(bb);
                BB.addPhiForLocal(phi, (SSAPhiInstruction)this.undo((SSAInstruction)BB.getPhiForLocal(phi), ((PhiUseRecord)use).useNumber, lhs));
                SSAConversion.this.addUndoAddPhi(BB, BB.getPhiForLocal(phi));
                SSAConversion.this.addRedoAddPhi(BB, phi);
                SSAConversion.this.copyPropagationMap.remove(use);
            }
            Iterator<CopyPropagationRecord> cs = this.childRecords.iterator();
            while (cs.hasNext()) {
                cs.next().undo(lhs);
            }
        }

        public void undo() {
            this.undo(this.rhs);
            SSAConversion.this.copyPropagationMap.remove(new UseRecord(this.instructionIndex, this.rhs));
        }
    }

    private class PhiUseRecord {
        final int BBnumber;
        final int phiNumber;
        final int useNumber;

        private PhiUseRecord(int BBnumber, int phiNumber, int useNumber) {
            this.BBnumber = BBnumber;
            this.phiNumber = phiNumber;
            this.useNumber = useNumber;
        }

        public int hashCode() {
            return this.phiNumber * this.BBnumber * this.useNumber;
        }

        public boolean equals(Object o) {
            return o instanceof PhiUseRecord && this.BBnumber == ((PhiUseRecord)o).BBnumber && this.phiNumber == ((PhiUseRecord)o).phiNumber && this.useNumber == ((PhiUseRecord)o).useNumber;
        }
    }

    private static class UseRecord {
        final int instructionIndex;
        final int useNumber;

        private UseRecord(int instructionIndex, int useNumber) {
            this.useNumber = useNumber;
            this.instructionIndex = instructionIndex;
        }

        public int hashCode() {
            return this.useNumber * this.instructionIndex;
        }

        public boolean equals(Object o) {
            return o instanceof UseRecord && this.instructionIndex == ((UseRecord)o).instructionIndex && this.useNumber == ((UseRecord)o).useNumber;
        }
    }

    public class AssignInstruction
    extends SSAUnaryOpInstruction {
        public AssignInstruction(int instructionIndex, int result, int val) {
            super(instructionIndex, null, result, val);
            assert (result != val);
            assert (result != -1);
            assert (val != -1);
        }

        public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
            return new AssignInstruction(this.iindex, defs == null ? this.getDef(0) : defs[0], uses == null ? this.getUse(0) : uses[0]);
        }

        public String toString(SymbolTable symbolTable) {
            return this.getValueString(symbolTable, this.result) + " := " + this.getValueString(symbolTable, this.val);
        }

        public void visit(SSAInstruction.IVisitor v) {
            v.visitUnaryOp((SSAUnaryOpInstruction)this);
        }

        public int getVal() {
            return this.getUse(0);
        }
    }

    public static class RedoRewriteInstruction
    extends RedoSSAConversion {
        private final SSAInstruction[] instructions;
        private final int index;
        private final SSAInstruction inst;

        public RedoRewriteInstruction(SSAInstruction[] instructions, int index, SSAInstruction inst, IRedoSSAConversion next) {
            super(next);
            this.instructions = instructions;
            this.index = index;
            this.inst = inst;
        }

        public void undo() {
            super.redo();
            this.instructions[this.index] = this.inst;
        }
    }

    public static class UndoRewriteInstruction
    extends UndoSSAConversion {
        private final SSAInstruction[] instructions;
        private final int index;
        private final SSAInstruction inst;

        public UndoRewriteInstruction(SSAInstruction[] instructions, int index, SSAInstruction inst, IUndoSSAConversion next) {
            super(next);
            this.instructions = instructions;
            this.index = index;
            this.inst = inst;
        }

        @Override
        public void undo() {
            this.instructions[this.index] = this.inst;
            super.undo();
        }
    }

    public static class RedoAddPhi
    extends RedoSSAConversion {
        private final SSACFG.BasicBlock bb;
        private final int index;
        private final SSAPhiInstruction phi;

        public RedoAddPhi(SSACFG.BasicBlock bb, int index, SSAPhiInstruction phi, IRedoSSAConversion next) {
            super(next);
            this.bb = bb;
            this.index = index;
            this.phi = phi;
        }

        @Override
        public void redo() {
            super.redo();
            this.bb.addPhiForLocal(this.index, this.phi);
        }
    }

    public static class UndoAddPhi
    extends UndoSSAConversion {
        private final SSACFG.BasicBlock bb;
        private final SSAPhiInstruction phi;

        public UndoAddPhi(SSACFG.BasicBlock bb, SSAPhiInstruction phi, IUndoSSAConversion next) {
            super(next);
            this.bb = bb;
            this.phi = phi;
        }

        @Override
        public void undo() {
            this.bb.removePhis(Collections.singleton(this.phi));
            super.undo();
        }
    }

    public static class RedoSSAConversion
    implements IRedoSSAConversion {
        private final IRedoSSAConversion next;

        public RedoSSAConversion(IRedoSSAConversion next) {
            this.next = next;
        }

        @Override
        public void redo() {
            if (this.next != null) {
                this.next.redo();
            }
        }
    }

    public static class UndoSSAConversion
    implements IUndoSSAConversion {
        private final IUndoSSAConversion next;

        public UndoSSAConversion(IUndoSSAConversion next) {
            this.next = next;
        }

        @Override
        public void undo() {
            if (this.next != null) {
                this.next.undo();
            }
        }
    }

    public static interface IRedoSSAConversion {
        public void redo();
    }

    public static interface IUndoSSAConversion {
        public void undo();
    }
}

