/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.stringAnalysis.translator.ConstraintSolverBuilder;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.RefinementBasedSolverCache;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;

public abstract class RefinementBasedConstraintSolverBuilder<T>
extends ConstraintSolverBuilder<T> {
    private RefinementBasedSolverCache<T> cache;
    private int limit = Integer.MAX_VALUE;
    private T any;

    public RefinementBasedConstraintSolverBuilder(T any, MonitorUtil.IProgressMonitor monitor) {
        this(any, Integer.MAX_VALUE, monitor);
    }

    public RefinementBasedConstraintSolverBuilder(T any, int initialLevel, MonitorUtil.IProgressMonitor monitor) {
        super(monitor);
        this.any = any;
        this.setRefinementLevel(initialLevel);
    }

    @Override
    protected Pair<ISolverCache<T>, ISolverStack> createSolverCacheAndStack(IVariableFactory<IVariable> varFactory) {
        Pair base = super.createSolverCacheAndStack(varFactory);
        this.cache = new RefinementBasedSolverCache<T>((ISolverCache)base.fst, (ISolverStack)base.snd, this.any, this.limit);
        return Pair.make(this.cache, (Object)base.snd);
    }

    public void setRefinementLevel(int n) {
        this.limit = n;
        if (this.cache != null) {
            this.cache.setLimit(n);
        }
    }

    public int getRefinementLevel() {
        if (this.cache != null) {
            return this.cache.getLimit();
        }
        return this.limit;
    }

    public void clearCache() {
        this.cache.clear();
    }
}

