/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.VariableReplacer;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.SSA2RuleFilter;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class SSA2RuleEffectFilter<T>
extends SSA2RuleFilter<T> {
    public SSA2RuleEffectFilter(ISSA2Rule<T> ssa2rule) {
        super(ssa2rule);
    }

    protected abstract boolean isUpdator(SSAAbstractInvokeInstruction var1, TranslationContext var2);

    protected abstract boolean isUpdateChain(SSAAbstractInvokeInstruction var1, TranslationContext var2);

    protected int[] getUpdateTarget(SSAAbstractInvokeInstruction instruction, TranslationContext ctx) {
        SSAAbstractInvokeInstruction pre;
        int recv = instruction.getReceiver();
        SSAInstruction i = ctx.getDefUse().getDef(recv);
        if (i instanceof SSAAbstractInvokeInstruction && this.isUpdateChain(pre = (SSAAbstractInvokeInstruction)i, ctx)) {
            return this.getUpdateTarget(pre, ctx);
        }
        return new int[]{instruction.getReceiver()};
    }

    protected abstract boolean hasAffectedParameters(SSAAbstractInvokeInstruction var1, TranslationContext var2);

    protected abstract int[] getAffectedParameters(SSAAbstractInvokeInstruction var1, TranslationContext var2);

    @Override
    public Collection<GRule> translate(SSAInstruction instruction, TranslationContext ctx) {
        Collection<GRule> rules = super.translate(instruction, ctx);
        if (instruction instanceof SSAAbstractInvokeInstruction) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
            if (this.isUpdator(invoke, ctx)) {
                HashSet<GRule> newRules = new HashSet<GRule>();
                for (GRule rule : rules) {
                    for (int lv : this.getUpdateTarget(invoke, ctx)) {
                        for (IVariable recv : this.getSymbolFactory().createCDVariable(lv, ctx)) {
                            for (IVariable irecv : this.getSymbolFactory().createCDVariable(invoke.getReceiver(), ctx)) {
                                GRule vr = new GRule(rule.getIR(), rule.getSSAInstruction(), recv, new ISymbol[]{irecv});
                                newRules.add(vr);
                            }
                            HashMap<IVariable, IVariable> m = new HashMap<IVariable, IVariable>();
                            m.put(rule.getLeft(), recv);
                            GRule nr = (GRule)rule.copy((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacer(m)));
                            newRules.add(nr);
                        }
                    }
                }
                return newRules;
            }
            if (this.hasAffectedParameters(invoke, ctx)) {
                int[] params = this.getAffectedParameters(invoke, ctx);
                HashSet<GRule> newRules = new HashSet<GRule>();
                for (int i = 0; i < params.length; ++i) {
                    int n = params[i];
                    int v = invoke.getUse(n);
                    for (GRule rule : rules) {
                        rule = this.appendSignature(rule, "->" + n);
                        for (IVariable var : this.getSymbolFactory().createCDVariable(v, ctx)) {
                            for (IVariable ivar : this.getSymbolFactory().createCDVariable(v, ctx)) {
                                GRule vr = new GRule(rule.getIR(), rule.getSSAInstruction(), var, new ISymbol[]{ivar});
                                newRules.add(vr);
                            }
                            HashMap m = new HashMap();
                            m.put(rule.getLeft(), var);
                            GRule nr = (GRule)rule.copy((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacer((Map)m)));
                            newRules.add(nr);
                        }
                    }
                }
                return newRules;
            }
        }
        return rules;
    }

    private GRule appendSignature(GRule rule, String append) {
        List l = rule.getRight();
        if (l.size() != 1) {
            return rule;
        }
        ISymbol sym0 = (ISymbol)l.get(0);
        if (!(sym0 instanceof InvocationSymbol)) {
            return rule;
        }
        InvocationSymbol isym = (InvocationSymbol)sym0;
        SignatureSymbol signature = new SignatureSymbol(isym.getFunction().getName() + append);
        InvocationSymbol isym2 = new InvocationSymbol(isym.getCallGraph(), isym.getCGNode(), isym.getInstruction(), signature, isym.getReceiver(), isym.getParameters());
        return new GRule(rule.getIR(), rule.getSSAInstruction(), rule.getLeft(), isym2);
    }
}

