/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.grammar.string.CFLTranslator;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.ITransitionVisitor;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringTranslator;
import com.ibm.wala.util.MonitorUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Transducer
extends StringTranslator {
    public static final boolean USE_REGULAR_APPROXIMATION = Boolean.getBoolean("com.ibm.wala.stringAnalysis.translator.useRegularApproximation");
    private IAutomaton transducer;

    public Transducer(int target) {
        super(target);
    }

    public Transducer() {
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IContextFreeGrammar> translator, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar g) {
        SimpleGrammar g2 = super.prepare(translator, funcName, recv, params, rule, g);
        try {
            this.transducer = this.createTransducer();
        }
        catch (TranslationException e) {
            this.transducer = null;
        }
        return g2;
    }

    protected abstract IAutomaton createTransducer() throws TranslationException;

    protected IAutomaton getTransducer(IContextFreeGrammar g) {
        return this.transducer;
    }

    @Override
    public IContextFreeGrammar translate(IContextFreeGrammar g) throws TranslationException {
        if (USE_REGULAR_APPROXIMATION) {
            return this.translateAsRegular(g);
        }
        return this.translateAsCFG(g);
    }

    protected IContextFreeGrammar translateAsCFG(IContextFreeGrammar g) throws TranslationException {
        IAutomaton transducer = this.getTransducer(g);
        if (transducer == null) {
            throw new TranslationException("The transducer was not created.");
        }
        IContextFreeGrammar g2 = CFLTranslator.translate((IAutomaton)transducer, (IContextFreeGrammar)g, (IVariableFactory)this.varFactory, (MonitorUtil.IProgressMonitor)this.monitor);
        return g2;
    }

    protected IContextFreeGrammar translateAsRegular(IContextFreeGrammar g) throws TranslationException {
        IAutomaton transducer = this.getTransducer(g);
        if (transducer == null) {
            throw new TranslationException("The transducer was not created.");
        }
        IAutomaton a1 = Grammars.toAutomaton((IContextFreeGrammar)g);
        IAutomaton a1m = Automatons.minimize((IAutomaton)a1);
        IAutomaton a2 = Automatons.translateAutomaton((IAutomaton)transducer, (IAutomaton)a1m, (MonitorUtil.IProgressMonitor)this.monitor);
        return Grammars.toCFG((IAutomaton)a2);
    }

    public boolean acceptCyclic() {
        return false;
    }

    public SimpleGrammar translateCyclic(SimpleGrammar g, Set<ISymbol> terminals) {
        System.err.println("Warning: cyclic constraint: " + this.funcName);
        IContextFreeGrammar g2 = Grammars.toCFG((IAutomaton)this.transducer, terminals, (Grammars.ITransitionSymbol)Grammars.TransitionOutput.defaultInstance, (IVariableFactory)this.varFactory);
        return g2.toSimple();
    }

    protected Set<ISymbol> possibleOutputs(Set<ISymbol> inputs) {
        final HashSet<ISymbol> outputs = new HashSet<ISymbol>();
        if (this.transducer == null) {
            outputs.add((ISymbol)new RangeSymbol('\u0000', '\uffff'));
        } else {
            IAutomaton fst = Automatons.expand((IAutomaton)this.transducer, inputs);
            fst.traverseTransitions(new ITransitionVisitor(){

                public void onVisit(ITransition transition) {
                    outputs.addAll(transition.getOutputSymbols());
                }
            });
        }
        return outputs;
    }

    @Override
    public IContextFreeGrammar possibleGrammar(IContextFreeGrammar g) {
        HashSet<ISymbol> outputs = new HashSet<ISymbol>();
        outputs.addAll(this.possibleOutputs(Grammars.collectTerminals((IGrammar[])new IGrammar[]{g})));
        return this.possibleStringsAsCFG(outputs, true);
    }
}

