/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.concurrent;

import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.stringAnalysis.translator.CG2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.ITypeInferenceBuilder;
import com.ibm.wala.util.MonitorUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class ConcurrentCG2Grammar
extends CG2Grammar<IContextFreeGrammar> {
    private final Server[] servers;

    public ConcurrentCG2Grammar(IIR2Grammar<IContextFreeGrammar> ir2gr, ITypeInferenceBuilder builder, int nThread, MonitorUtil.IProgressMonitor progressMonitor, Logger logger) {
        super(ir2gr, builder, progressMonitor, logger);
        this.servers = new Server[nThread];
    }

    public ConcurrentCG2Grammar(IIR2Grammar<IContextFreeGrammar> ir2gr, int nThread, MonitorUtil.IProgressMonitor progressMonitor, Logger logger) {
        super(ir2gr, progressMonitor, logger);
        this.servers = new Server[nThread];
    }

    protected Collection<IProductionRule> translateNodes(CallGraph callGraph, PointerAnalysis pointerAnalysis, CGNode fakeRootNode, ISSA2Rule<IContextFreeGrammar> ssa2rule, MonitorUtil.IProgressMonitor progressMonitor) {
        int i;
        Iterator<CGNode> iter = this.nodeIterator(callGraph);
        ConcurrentLinkedQueue<CGNode> nodeQueue = new ConcurrentLinkedQueue<CGNode>();
        ConcurrentLinkedQueue<IProductionRule> rules = new ConcurrentLinkedQueue<IProductionRule>();
        while (iter.hasNext()) {
            nodeQueue.add(iter.next());
        }
        for (i = 0; i < this.servers.length; ++i) {
            this.servers[i] = new Server(rules, nodeQueue, callGraph, pointerAnalysis, ssa2rule, progressMonitor);
            this.servers[i].start();
        }
        for (i = 0; i < this.servers.length; ++i) {
            try {
                this.servers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return rules;
    }

    protected class Server
    extends Thread {
        private final Collection<IProductionRule> rules;
        private final Queue<CGNode> nodeQueue;
        private final CallGraph callGraph;
        private final PointerAnalysis pointerAnalysis;
        private final ISSA2Rule<IContextFreeGrammar> ssa2rule;

        public Server(Collection<IProductionRule> rules, Queue<CGNode> nodeQueue, CallGraph callGraph, PointerAnalysis pointerAnalysis, ISSA2Rule<IContextFreeGrammar> ssa2rule, MonitorUtil.IProgressMonitor progressMonitor) {
            this.rules = rules;
            this.nodeQueue = nodeQueue;
            this.callGraph = callGraph;
            this.pointerAnalysis = pointerAnalysis;
            this.ssa2rule = ssa2rule;
            this.setUncaughtExceptionHandler(Thread.getDefaultUncaughtExceptionHandler());
        }

        @Override
        public void run() {
            CGNode node = this.nodeQueue.poll();
            while (node != null) {
                ConcurrentCG2Grammar.this.translateNode(this.rules, node, this.callGraph, this.pointerAnalysis, this.ssa2rule);
                node = this.nodeQueue.poll();
            }
        }
    }
}

