/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.python;

import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.discovery.dir.BaseCustomCollector;
import com.ibm.appscan.discovery.python.IPythonConstants;
import com.ibm.appscan.internal.discovery.python.PythonStrategy;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;

public class PythonCollector
extends BaseCustomCollector
implements IPythonConstants {
    private static boolean m_checkedForPython = false;
    private static boolean m_containsPython = false;

    public PythonCollector(File crawlRoot, Set<StringPattern> includes, Set<StringPattern> excludes) {
        super(crawlRoot, includes, excludes);
    }

    public String getType() {
        return "PythonCollector";
    }

    protected String getFileExtensionSetName() {
        return "python";
    }

    protected ScanTargetStrategy getScanTargetStrategy(ScanTargetStrategy parentStrategy) {
        return new PythonStrategy(this.getCrawlRoot().getAbsolutePath(), this.getScanFiles());
    }

    protected boolean acceptFile(File file) {
        return super.acceptFile(file) || this.containsPython() && FileUtil.getFileExtension((File)file).toLowerCase().equals("html");
    }

    private boolean containsPython() {
        if (!m_checkedForPython && this.getCrawlRoot().isDirectory()) {
            m_checkedForPython = true;
            File[] files = this.getCrawlRoot().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return PythonCollector.this.acceptFile(file);
                }
            });
            m_containsPython = files.length != 0;
        }
        return m_containsPython;
    }
}

