/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.samso.client;

import com.ibm.wala.automaton.regex.string.IPatternCompiler;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.samso.client.IM2LStringVerifier;
import com.ibm.wala.samso.m2lstr.DeclarationSets;
import com.ibm.wala.samso.m2lstr.IExtendedFormulaFactory;
import com.ibm.wala.samso.m2lstr.IFormula;
import com.ibm.wala.samso.m2lstr.IPositionSetVariable;
import com.ibm.wala.samso.m2lstr.RegexpToM2L;
import com.ibm.wala.samso.solver.MONA;
import com.ibm.wala.samso.solver.StringConstraintSolver;
import com.ibm.wala.samso.translator.IDeclarationSet;
import com.ibm.wala.samso.translator.repository.M2LTranslatorRepository;
import com.ibm.wala.stringAnalysis.client.GrammarBasedStringVerifier;
import com.ibm.wala.stringAnalysis.client.IGrammarBasedStringAnalyzer;
import com.ibm.wala.util.MonitorUtil;
import java.util.Arrays;

public class M2LStringVerifier
extends GrammarBasedStringVerifier<IDeclarationSet>
implements IM2LStringVerifier {
    private final StringConstraintSolver solver;
    private final MONA mona;
    private final IPatternCompiler<IDeclarationSet> m2lc;
    private final IExtendedFormulaFactory ffactory;

    public long getLastSolvingTime() {
        return this.mona.getLastSolvingTime();
    }

    public long getTotalSolvingTime() {
        return this.mona.getTotalSolvingTime();
    }

    public long getLastNumberOfPredicates() {
        return this.mona.getLastNumberOfPredicates();
    }

    public long getLastNumberOfDAGNodes() {
        return this.mona.getLastNumberOfDAGNodes();
    }

    public long getLastNumberOfReducedDAGNodes() {
        return this.mona.getLastNumberOfReducedDAGNodes();
    }

    public long getLastNumberOfStates() {
        return this.mona.getLastNumberOfStates();
    }

    public long getLastNumberOfBDDNodes() {
        return this.mona.getLastNumberOfBDDNodes();
    }

    public long getLastNumberOfAutomata() {
        return this.mona.getLastNumberOfAutomata();
    }

    private void addTarget(IDeclarationSet decls) {
        IPositionSetVariable R = this.ffactory.createPositionSetVariable();
        decls.add(this.ffactory.createPositionSetVariableDefinition(R));
        decls.add(this.ffactory.createFormulaDeclaration(this.ffactory.createApplyPredicate(decls.getTarget(), R)));
    }

    public M2LStringVerifier(IGrammarBasedStringAnalyzer<IDeclarationSet> analyzer, MonitorUtil.IProgressMonitor monitor) {
        super(analyzer, monitor);
        this.ffactory = ((M2LTranslatorRepository)analyzer.getRepository()).getFormulaFactory();
        this.solver = new StringConstraintSolver(this.ffactory, monitor);
        this.mona = this.solver.getMONA();
        this.m2lc = new RegexpToM2L(this.ffactory);
    }

    protected boolean checkValidity(IDeclarationSet declSet) {
        this.solver.clear();
        this.solver.read(declSet);
        return this.solver.checkValidity();
    }

    protected boolean checkSatisfiability(IDeclarationSet declSet) {
        this.solver.clear();
        this.solver.read(declSet);
        return this.solver.checkSatisfiability();
    }

    public boolean containsAll(IAutomaton pattern, IDeclarationSet g) {
        IDeclarationSet spec = (IDeclarationSet)this.m2lc.compile(Automatons.toRegex((IAutomaton)pattern));
        IDeclarationSet decls = DeclarationSets.createImply(g, spec, this.ffactory);
        this.addTarget(decls);
        return this.checkValidity(decls);
    }

    public boolean containsSome(IDeclarationSet g, IAutomaton pattern) {
        IDeclarationSet spec = (IDeclarationSet)this.m2lc.compile(Automatons.toRegex((IAutomaton)pattern));
        IDeclarationSet declSet = DeclarationSets.createIntersection(Arrays.asList(g, spec), this.ffactory);
        this.addTarget(declSet);
        return this.checkSatisfiability(declSet);
    }

    public boolean containsStringSometimes(IDeclarationSet g, String str) {
        IPositionSetVariable R = this.ffactory.createPositionSetVariable();
        IPositionSetVariable S = this.ffactory.createPositionSetVariable();
        IFormula specFormula = this.ffactory.createExists(S, this.ffactory.createAnd(this.ffactory.createSubset(S, R), this.ffactory.createIsStr(str, S)));
        IDeclarationSet spec = DeclarationSets.createDeclarationSet(R, specFormula, this.ffactory);
        IDeclarationSet declSet = DeclarationSets.createIntersection(Arrays.asList(g, spec), this.ffactory);
        this.addTarget(declSet);
        return this.checkSatisfiability(declSet);
    }

    public boolean containsStringAlways(IDeclarationSet g, String str) {
        IPositionSetVariable R = this.ffactory.createPositionSetVariable();
        IPositionSetVariable S = this.ffactory.createPositionSetVariable();
        IFormula specFormula = this.ffactory.createExists(S, this.ffactory.createAnd(this.ffactory.createSubset(S, R), this.ffactory.createIsStr(str, S)));
        IDeclarationSet spec = DeclarationSets.createDeclarationSet(R, specFormula, this.ffactory);
        IDeclarationSet declSet = DeclarationSets.createImply(g, spec, this.ffactory);
        this.addTarget(declSet);
        return this.checkValidity(declSet);
    }
}

