/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.common.thirdpartylib.license;

import com.hcl.appscan.common.thirdpartylib.license.ILicense;
import com.hcl.appscan.common.thirdpartylib.license.License;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class LicensesFileLoader {
    private List<ILicense> m_licenses;
    private LinkedHashMap<Integer, String> m_dictionary;
    private HashMap<String, String> m_properties;
    private XMLStreamReader m_reader;
    private File m_file;

    public LicensesFileLoader(File file) {
        this.m_file = file;
    }

    protected File getFile() {
        return this.m_file;
    }

    protected XMLStreamReader getReader() {
        return this.m_reader;
    }

    public List<ILicense> load() throws IOException, XMLStreamException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.m_reader = factory.createXMLStreamReader(new BufferedInputStream(new FileInputStream(this.getFile())));
            this.m_licenses = new ArrayList<ILicense>();
            this.m_dictionary = new LinkedHashMap();
            while (this.getReader().hasNext()) {
                int event = this.getReader().next();
                switch (event) {
                    case 1: {
                        this.processStartElement();
                        break;
                    }
                    case 2: {
                        this.processEndElement();
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        finally {
            if (this.getReader() != null) {
                this.getReader().close();
            }
        }
        return this.m_licenses;
    }

    protected String fromDictionary(int key) {
        String val = this.m_dictionary.get(key);
        if (val == null) {
            val = "";
        }
        return val;
    }

    protected void processEndElement() {
        if ("license".equals(this.getReader().getLocalName().toLowerCase())) {
            License license = new License(this.m_properties);
            this.m_licenses.add(license);
        }
    }

    protected void processStartElement() throws NumberFormatException, IOException {
        if ("item".equals(this.getReader().getLocalName().toLowerCase())) {
            this.m_dictionary.put(Integer.parseInt(this.getReader().getAttributeValue(0)), this.getReader().getAttributeValue(1));
        }
        if ("license".equals(this.getReader().getLocalName().toLowerCase())) {
            this.m_properties = new HashMap();
            int cnt = this.getReader().getAttributeCount();
            for (int inx = 0; inx < cnt; ++inx) {
                int id = Integer.parseInt(this.getReader().getAttributeValue(inx));
                String key = this.getReader().getAttributeName(inx).getLocalPart();
                String val = this.fromDictionary(id);
                this.m_properties.put(key, val);
            }
        }
    }
}

