/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.http;

import com.ibm.appscan.common.http.HttpPart;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.http.IHttpProgress;
import com.ibm.appscan.common.utils.HttpUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.common.http.DefaultHttpProgress;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HttpClient {
    private String m_boundary;
    private long m_totalMultipartLength;
    private long m_uploadedMultipartLength;
    private static final String CR_LF = "\r\n";
    private static final String TWO_HYPHENS = "--";
    private static final String HTTPS_PROXY_USER = "https.proxyUser";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private IHttpProgress m_progressAdapter;
    private static final int READ_SIZE = 16384;

    public HttpClient(IHttpProgress progressAdapter) {
        this.m_progressAdapter = progressAdapter;
    }

    public HttpClient() {
        this(new DefaultHttpProgress());
    }

    public HttpResponse get(String url, Map<String, String> headerProperties, char[] body) throws IOException {
        return this.makeRequest(Method.GET, url, headerProperties, body);
    }

    public HttpResponse post(String url, Map<String, String> headerProperties, char[] body) throws IOException {
        if (body == null) {
            body = "".toCharArray();
        }
        return this.makeRequest(Method.POST, url, headerProperties, body);
    }

    public HttpResponse put(String url, Map<String, String> headerProperties, char[] body) throws IOException {
        return this.makeRequest(Method.PUT, url, headerProperties, body);
    }

    public HttpResponse put(String url, Map<String, String> headerProperties, byte[] body) throws IOException {
        return this.makeRequest(Method.PUT, url, headerProperties, body);
    }

    public HttpResponse delete(String url, Map<String, String> headerProperties, char[] body) throws IOException {
        return this.makeRequest(Method.DELETE, url, headerProperties, body);
    }

    public HttpResponse getForm(String url, Map<String, String> headerProperties, Map<String, char[]> params) throws IOException {
        return this.get(url, headerProperties, HttpUtil.buildQueryString(params));
    }

    public HttpResponse postForm(String url, Map<String, String> headerProperties, Map<String, char[]> params) throws IOException {
        return this.post(url, headerProperties, HttpUtil.buildQueryString(params));
    }

    public HttpResponse putForm(String url, Map<String, String> headerProperties, Map<String, char[]> params) throws IOException {
        return this.put(url, headerProperties, HttpUtil.buildQueryString(params));
    }

    public HttpResponse deleteForm(String url, Map<String, String> headerProperties, Map<String, char[]> params) throws IOException {
        return this.delete(url, headerProperties, HttpUtil.buildQueryString(params));
    }

    public HttpResponse postMultipart(String url, Map<String, String> headerProperties, List<HttpPart> parts) throws IOException {
        this.m_boundary = "*****" + Long.toString(System.currentTimeMillis()) + "*****";
        headerProperties.put("Content-Type", "multipart/form-data; boundary=" + this.m_boundary);
        return this.makeMultipartRequest(Method.POST, url, headerProperties, parts);
    }

    private HttpResponse makeMultipartRequest(Method method, String url, Map<String, String> headerProperties, List<HttpPart> parts) throws IOException {
        HttpURLConnection conn = this.makeConnection(url, method, headerProperties);
        DataOutputStream outputStream = null;
        conn.setChunkedStreamingMode(1024);
        if (parts != null && !parts.isEmpty()) {
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            outputStream = new DataOutputStream(conn.getOutputStream());
            this.m_uploadedMultipartLength = 0L;
            this.m_totalMultipartLength = this.getTotalPartsLength(parts);
            this.updateProgress();
            for (HttpPart part : parts) {
                int bytesRead;
                StringBuilder builder = new StringBuilder();
                builder.append(TWO_HYPHENS + this.m_boundary + CR_LF);
                Map<String, String> partHeaders = part.getPartHeaders();
                for (String header : partHeaders.keySet()) {
                    builder.append(header + ": " + partHeaders.get(header) + CR_LF);
                }
                outputStream.writeBytes(builder.toString() + CR_LF);
                outputStream.flush();
                byte[] buffer = new byte[1024];
                while ((bytesRead = part.getPartBodyInputStream().read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    this.m_uploadedMultipartLength += (long)bytesRead;
                    this.updateProgress();
                }
                outputStream.writeBytes(CR_LF);
                outputStream.flush();
            }
            outputStream.writeBytes(TWO_HYPHENS + this.m_boundary + TWO_HYPHENS + CR_LF);
            outputStream.flush();
            this.updateProgress();
        }
        outputStream.flush();
        outputStream.close();
        this.m_progressAdapter.endProgress();
        return this.getHttpResponse(conn);
    }

    private HttpResponse makeRequest(Method method, String url, Map<String, String> headerProperties, char[] payload) throws IOException {
        HttpURLConnection conn = this.makeConnection(url, method, headerProperties);
        if (payload != null) {
            conn.setDoOutput(true);
            DataOutputStream writer = new DataOutputStream(conn.getOutputStream());
            for (char c : payload) {
                writer.write(c);
            }
            writer.flush();
            writer.close();
        }
        return this.getHttpResponse(conn);
    }

    private HttpResponse makeRequest(Method method, String url, Map<String, String> headerProperties, byte[] payload) throws IOException {
        HttpURLConnection conn = this.makeConnection(url, method, headerProperties);
        if (payload != null) {
            conn.setDoOutput(true);
            DataOutputStream writer = new DataOutputStream(conn.getOutputStream());
            for (byte c : payload) {
                writer.write(c);
            }
            writer.flush();
            writer.close();
        }
        return this.getHttpResponse(conn);
    }

    private HttpURLConnection makeConnection(String url, Method method, Map<String, String> headerProperties) throws IOException {
        URL requestURL = new URL(url);
        HttpURLConnection conn = null;
        conn = (HttpURLConnection)requestURL.openConnection();
        conn.setRequestMethod(method.name());
        conn.setReadTimeout(0);
        if (headerProperties != null) {
            for (String key : headerProperties.keySet()) {
                conn.setRequestProperty(key, headerProperties.get(key));
            }
        }
        return conn;
    }

    private HttpResponse getHttpResponse(HttpURLConnection conn) throws IOException {
        boolean error;
        byte[] contentBytes = null;
        int responseCode = conn.getResponseCode();
        boolean bl = error = responseCode < 200 || responseCode >= 300;
        if (responseCode != 204) {
            InputStream is;
            int contentLength = conn.getContentLength();
            InputStream inputStream = is = error ? conn.getErrorStream() : conn.getInputStream();
            if (contentLength == -1) {
                byte[] buf = new byte[16384];
                int bufferLeft = buf.length;
                int offset = 0;
                int result = 0;
                while (true) {
                    if (bufferLeft > 0) {
                        result = is.read(buf, offset, bufferLeft);
                        if (result < 0) break;
                        offset += result;
                        bufferLeft -= result;
                        continue;
                    }
                    bufferLeft = 16384;
                    int newSize = buf.length + 16384;
                    byte[] newBuf = new byte[newSize];
                    System.arraycopy(buf, 0, newBuf, 0, buf.length);
                    buf = newBuf;
                }
                contentBytes = new byte[offset];
                System.arraycopy(buf, 0, contentBytes, 0, offset);
            } else {
                BufferedInputStream in = new BufferedInputStream(is);
                contentBytes = new byte[contentLength];
                int bytesRead = 0;
                for (int offset = 0; offset < contentLength && (bytesRead = ((InputStream)in).read(contentBytes, offset, contentBytes.length - offset)) != -1; offset += bytesRead) {
                }
                ((InputStream)in).close();
            }
        }
        HttpResponse response = new HttpResponse();
        response.setResponseCode(responseCode);
        response.setResponseHeaders(conn.getHeaderFields());
        response.setRawContent(contentBytes);
        return response;
    }

    private long getTotalPartsLength(List<HttpPart> parts) {
        long totalSize = 0L;
        for (HttpPart part : parts) {
            totalSize += part.getPartLength();
        }
        return totalSize;
    }

    private void updateProgress() {
        int progress = (int)((float)this.m_uploadedMultipartLength / (float)this.m_totalMultipartLength * 100.0f);
        this.m_progressAdapter.setProgress(progress);
    }

    static {
        String proxyPassword;
        SystemUtil.setSystemProperties();
        final String proxyUser = !SystemUtil.isPropertySet(HTTPS_PROXY_USER) ? System.getProperty(HTTP_PROXY_USER) : System.getProperty(HTTPS_PROXY_USER);
        String string = proxyPassword = !SystemUtil.isPropertySet(HTTPS_PROXY_PASSWORD) ? System.getProperty(HTTP_PROXY_PASSWORD) : System.getProperty(HTTPS_PROXY_PASSWORD);
        if (proxyUser != null && proxyPassword != null) {
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                }
            });
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

